/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringBeanMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;

public class StringBeanMessageHandler implements
		MessageHandler.Whole<StringBean> {

	private Session session;
	public static final String HANDLER_SAYS = "StringBeanMessageHandler says: ";

	public StringBeanMessageHandler(Session session) {
		this.session = session;
	}

	@Override
	public void onMessage(StringBean message) {
		try {
			session.getBasicRemote().sendText(HANDLER_SAYS + message.get());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
