/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AlternativeReaderDecoder.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.common;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;

public class AlternativeReaderDecoder implements Decoder.Text<Reader> {

	public static final String DECODER_SAYS = "Reader decoder";

	@Override
	public void init(EndpointConfig config) {
	}

	@Override
	public void destroy() {
	}

	@Override
	public Reader decode(String s) throws DecodeException {
		ByteArrayInputStream bais = new ByteArrayInputStream(
				(DECODER_SAYS + s).getBytes());
		Reader r = new InputStreamReader(bais);
		return r;
	}

	@Override
	public boolean willDecode(String s) {
		return true;
	}

}
