/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AppConfig.java 72822 2013-09-06 13:11:15Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig.configurator;

import java.util.HashSet;
import java.util.Set;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

/**
 * for extensions to test, programmatic endpoint is to be deployed 
 */
public class AppConfig implements ServerApplicationConfig {

	@Override
	public Set<ServerEndpointConfig> getEndpointConfigs(
			Set<Class<? extends Endpoint>> endpointClasses) {
		Set<ServerEndpointConfig> set = new HashSet<ServerEndpointConfig>();
		set.add(new ExtensionsServerEndpointConfig());
		set.add(new SubprotocolsServerEndpointConfig());
		return set;
	}

	@Override
	public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
		Set<Class<?>> set = new HashSet<Class<?>>();
		set.add(WSCGetEndpointInstanceServer.class);
		set.add(WSCOriginServer.class);
		set.add(WSCOriginServerReturningFalse.class);
		set.add(WSCOriginServerReturningFalseConfigurator.class);	
		set.add(WSCModifyHandshakeServer.class);
		return set;
	}
}
