/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSDirectLongPathParamServer.java 72767 2013-09-03 08:54:54Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.pathparam;

import java.io.IOException;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/{param1}")
public class WSDirectLongPathParamServer {
	private final static String ERR = "TCK INTENDED ERROR";
	private String p;

	@OnOpen
	public void onOpen(@PathParam("param1") Long p1) {
		p = p1.toString();
	}

	@OnMessage
	public String param(@PathParam("param1") Long p1, String content)
			throws IOException {
		OPS op = OPS.valueOf(content);
		switch (op) {
		case OPEN:
			content = p;
			break;
		case MESSAGE:
			content = p1.toString();
			break;
		case IOEXCEPTION:
			throw new IOException(ERR);
		case RUNTIMEEXCEPTION:
			throw new RuntimeException(ERR);
		}
		return content;
	}

	@OnError
	public void onError(@PathParam("param1") Long p1, Session session,
			Throwable t) throws IOException {
		String msg = t.getMessage();
		if (ERR.equals(msg)) {
			session.getBasicRemote().sendText(p1.toString());
		} else {
			t.printStackTrace(); // Write to error log, too
			String message = IOUtil.printStackTrace(t);
			session.getBasicRemote().sendText(message);
		}
	}

	@OnClose
	public void onClose(@PathParam("param1") Long p1) {
		WSOnClosePathParamServer.set(0, p1.toString());
	}
}
