/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: EchoConfigurator.java 72300 2013-07-04 16:17:49Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.handshakeresponse;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class EchoConfigurator extends Configurator {
	static final String KEY = "ReadOnlyKey";
	static final String [] VALUES = { "ReadOnlyValue1", "ReadOnlyValue2" };

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		Map<String, List<String>> map = request.getHeaders();
		try {
			map.put(KEY, Arrays.asList(VALUES));
		} catch (Exception e) {
			// possible, but not mandatory
		}
		response.getHeaders().putAll(map);
	}
}
