/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCCloseClientEndpoint.java 73424 2014-01-29 15:46:51Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpoint;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;

@ClientEndpoint
public class WSCCloseClientEndpoint extends AnnotatedClientEndpoint<String> {
	boolean onCloseCalled = false;
	CountDownLatch countDown = new CountDownLatch(1);

	public WSCCloseClientEndpoint() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
		onCloseCalled = true;
		countDown.countDown();		
	}

	@OnError
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

	public void waitForClose(long seconds) {
		try {
			countDown.await(seconds, TimeUnit.SECONDS);
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

}
