/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.websocket.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.Extension;

public class TCKExtension implements Extension {

    private final String name;
    private final List<Parameter> parameters;

    public TCKExtension(String name) {
        this(name, null);
    }

    public TCKExtension(String name, List<Parameter> parameters) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }

        this.name = name;
        if (parameters != null) {
            this.parameters = Collections.unmodifiableList(new ArrayList<>(parameters));
        } else {
            this.parameters = Collections.unmodifiableList(Collections.<Parameter>emptyList());
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<Parameter> getParameters() {
        return parameters;
    }

    public static class TCKParameter implements Parameter {

        private final String name;
        private final String value;

        /**
         * Create {@link Parameter} with name and value.
         *
         * @param name  parameter name.
         * @param value parameter value.
         */
        public TCKParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public String getValue() {
            return value;
        }
    }
}
