/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class TRT_TreeNode
implements TestResultTable.TreeNode {
    private Object[] childs = null;
    private TRT_TreeNode parent;
    private TestResultTable table;
    private int counter = 0;
    private int[] childStats;
    private String name = null;
    private long lastScanDate;
    private static Hashtable observerTable = new Hashtable(16);
    private String[] filesToScan;
    protected static int debug = Debug.getInt(TRT_TreeNode.class);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TRT_TreeNode.class);

    @Override
    public synchronized void addObserver(TestResultTable.TreeNodeObserver obs) {
        Object[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers == null) {
            observers = new TestResultTable.TreeNodeObserver[]{};
        }
        observers = (TestResultTable.TreeNodeObserver[])DynamicArray.append(observers, obs);
        observerTable.put(this, observers);
    }

    @Override
    public synchronized void removeObserver(TestResultTable.TreeNodeObserver obs) {
        Object[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers == null) {
            return;
        }
        if ((observers = (TestResultTable.TreeNodeObserver[])DynamicArray.remove(observers, obs)) == null) {
            observerTable.remove(this);
        } else {
            observerTable.put(this, observers);
        }
    }

    @Override
    public int getSize() {
        this.scanSubtree(this);
        return this.counter;
    }

    public int getEstimatedSize() {
        return this.counter;
    }

    @Override
    public TestResultTable.TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public TestResultTable getEnclosingTable() {
        return this.table;
    }

    @Override
    public boolean isUpToDate() {
        return this.lastScanDate != 0L;
    }

    @Override
    public int getChildCount() {
        this.scanIfNeeded();
        if (this.childs == null) {
            return 0;
        }
        return this.childs.length;
    }

    @Override
    public Object getChild(int index) {
        return this.getChild(index, false);
    }

    Object getChild(int index, boolean suppressScan) {
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        if (this.childs == null || index >= this.childs.length) {
            return null;
        }
        return this.childs[index];
    }

    @Override
    public TestResult[] getTestResults() {
        this.scanIfNeeded();
        TestResult[] leafs = null;
        if (this.childs != null && this.childs.length != 0) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (!(this.childs[i] instanceof TestResult)) continue;
                leafs = (TestResult[])DynamicArray.append(leafs, this.childs[i]);
            }
        }
        return leafs;
    }

    @Override
    public TestResultTable.TreeNode[] getTreeNodes() {
        this.scanIfNeeded();
        if (this.childs == null) {
            return null;
        }
        TestResultTable.TreeNode[] leafs = null;
        for (int i = 0; i < this.childs.length; ++i) {
            if (!(this.childs[i] instanceof TestResultTable.TreeNode)) continue;
            leafs = (TestResultTable.TreeNode[])DynamicArray.append(leafs, this.childs[i]);
        }
        return leafs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLeaf(int index) {
        this.scanIfNeeded();
        if (index < 0 || index >= this.childs.length) {
            return false;
        }
        if (this.childs[index] instanceof TestResult) {
            return true;
        }
        if (this.childs[index] instanceof TRT_TreeNode) {
            return this.childs == null || this.childs.length == 0;
        }
        return false;
    }

    @Override
    public int[] getChildStatus() {
        this.scanSubtree(this);
        if (this.childStats == null) {
            TRT_TreeNode.refreshChildStats(this);
        }
        return this.childStats;
    }

    @Override
    public int getIndex(Object target) {
        return this.getIndex(target, false);
    }

    int getIndex(Object target, boolean suppressScan) {
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        if (target == null) {
            return -2;
        }
        if (this.childs == null) {
            return -1;
        }
        for (int i = 0; i < this.childs.length; ++i) {
            if (this.childs[i] != target) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TestResult matchTest(String url) {
        this.scanIfNeeded();
        if (debug > 1) {
            Debug.println("Matching Test URL: " + this.name + " in " + this);
        }
        TestResult found = null;
        if (this.childs == null || this.childs.length == 0) {
            return null;
        }
        for (int i = 0; i < this.childs.length; ++i) {
            if (!(this.childs[i] instanceof TestResult)) continue;
            TestResult tr = (TestResult)this.childs[i];
            try {
                String name = tr.getDescription().getRootRelativeURL();
            }
            catch (TestResult.Fault f) {
                throw new JavaTestError(i18n, "trttn.noTd", f);
            }
            if (debug > 1) {
                Debug.println("   -> trying to match against " + this.name);
            }
            if (this.name.equals(url)) {
                found = (TestResult)this.childs[i];
                i = this.childs.length;
                continue;
            }
            found = null;
        }
        return found;
    }

    TRT_TreeNode(TestResultTable table, TestResultTable.TreeNode parent) {
        this.table = table;
        this.parent = (TRT_TreeNode)parent;
    }

    int getCurrentSize() {
        return this.counter;
    }

    void incChildStat(int which) {
        int n = which;
        this.childStats[n] = this.childStats[n] + 1;
    }

    void decChildStat(int which) {
        int n = which;
        this.childStats[n] = this.childStats[n] - 1;
    }

    void invalidateChildStats() {
        this.childStats = null;
        this.notifyCounterChange();
        TRT_TreeNode parent = (TRT_TreeNode)this.getParent();
        if (parent != null) {
            parent.invalidateChildStats();
        }
    }

    boolean isChildStatsValid() {
        return this.childStats == null;
    }

    static void bubbleUpChildStat(TRT_TreeNode node, int which) {
        int n = which;
        node.childStats[n] = node.childStats[n] + 1;
        TRT_TreeNode parent = (TRT_TreeNode)node.getParent();
        if (parent != null) {
            TRT_TreeNode.bubbleUpChildStat(parent, which);
        }
    }

    static void swapChildStat(TRT_TreeNode node, int oldStatus, int newStatus) {
        int n = oldStatus;
        node.childStats[n] = node.childStats[n] - 1;
        int n2 = newStatus;
        node.childStats[n2] = node.childStats[n2] + 1;
        TRT_TreeNode parent = (TRT_TreeNode)node.getParent();
        if (parent != null) {
            TRT_TreeNode.swapChildStat(parent, oldStatus, newStatus);
        }
    }

    void incNodeCounter() {
        ++this.counter;
    }

    TestResult getTestResult(String url) {
        int index = this.getTestIndex(url);
        if (index != -1) {
            try {
                return (TestResult)this.getChild(index);
            }
            catch (ClassCastException e) {
                throw new JavaTestError(i18n, "trttn.badCast");
            }
        }
        return null;
    }

    TRT_TreeNode getTreeNode(String name, boolean suppressScan) {
        int index;
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        if ((index = this.getNodeIndex(name, suppressScan)) != -1) {
            try {
                return (TRT_TreeNode)this.getChild(index, suppressScan);
            }
            catch (ClassCastException e) {
                throw new JavaTestError(i18n, "trttn.badCast");
            }
        }
        return null;
    }

    int getTestIndex(String url) {
        if (url == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        int location = this.getResultIndex(TestResult.getWorkRelativePath(url), false);
        return location;
    }

    synchronized int getResultIndex(String jtrPath, boolean suppressScan) {
        if (jtrPath == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        int found = -1;
        if (this.childs != null && this.childs.length != 0) {
            for (int i = 0; i < this.childs.length; ++i) {
                TestResult tr;
                if (!(this.childs[i] instanceof TestResult) || !(tr = (TestResult)this.childs[i]).getWorkRelativePath().equals(jtrPath)) continue;
                found = i;
                break;
            }
        }
        return found;
    }

    int getTestIndex(TestResult target, boolean suppressScan) {
        if (target == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        int location = this.getResultIndex(target.getWorkRelativePath(), suppressScan);
        return location;
    }

    synchronized int getNodeIndex(String name, boolean suppressScan) {
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        int found = -1;
        if (name == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        if (this.childs == null || this.childs.length == 0) {
            found = -1;
        } else {
            for (int i = 0; i < this.childs.length; ++i) {
                TRT_TreeNode tn;
                if (!(this.childs[i] instanceof TRT_TreeNode) || !(tn = (TRT_TreeNode)this.childs[i]).getName().equals(name)) continue;
                found = i;
                break;
            }
        }
        return found;
    }

    synchronized void scanIfNeeded() {
        long lmd;
        File thisDir;
        if (debug > 0) {
            Debug.println("starting scanIfNeeded() on node " + this.getName());
        }
        if (this.table.getTestFinder() == null || this.isUpToDate()) {
            return;
        }
        if (this.childs == null) {
            this.childs = new Object[0];
        }
        if (this.isRoot() && this.filesToScan == null) {
            thisDir = this.table.getTestSuiteRoot();
            this.lastScanDate = this.table.getLastModifiedTime(thisDir);
            this.processFile(thisDir);
            if (this.filesToScan == null) {
                this.filesToScan = new String[0];
            }
            for (int i = 0; i < this.filesToScan.length; ++i) {
                this.processFile(new File(this.filesToScan[i]));
            }
        }
        if ((lmd = this.table.getLastModifiedTime(thisDir = new File(TestResultTable.getRootRelativePath(this)))) <= this.lastScanDate) {
            return;
        }
        if (this.filesToScan != null) {
            for (int i = 0; i < this.filesToScan.length; ++i) {
                if (this.filesToScan[i] == this.name) {
                    this.processFile(thisDir);
                    continue;
                }
                this.processFile(new File(TestResultTable.getRootRelativePath(this) + File.separator + this.filesToScan[i]));
            }
        } else {
            if (debug > 0) {
                Debug.println("refreshing contents of " + this.getName() + this.lastScanDate);
            }
            this.refreshIfNeeded();
        }
        this.lastScanDate = lmd;
    }

    synchronized TestResult resetTest(int index, TestResult tr) {
        WorkDirectory workdir;
        if (this.childs[index] != tr) {
            return null;
        }
        File result = tr.getFile();
        WorkDirectory workDirectory = workdir = this.table == null ? null : this.table.getWorkDirectory();
        if (result == null && workdir != null) {
            result = workdir.getFile(tr.getWorkRelativePath());
        }
        if (result != null) {
            boolean wasDeleted = result.delete();
            workdir.clearAnnotations(tr);
        }
        String name = tr.getTestName();
        String filename = null;
        int lastSlash = name.lastIndexOf(47);
        int lastHash = name.lastIndexOf(35);
        filename = lastHash > lastSlash ? name.substring(0, lastHash) : name;
        TestResult newTr = null;
        TestDescription oldTd = null;
        try {
            oldTd = tr.getDescription();
        }
        catch (TestResult.Fault f) {
            // empty catch block
        }
        TestDescription newTd = this.updateTestDescription(name, oldTd);
        if (newTd == null) {
            newTd = new TestDescription(this.table.getTestFinder().getRoot(), new File(filename), new HashMap());
        }
        if ((newTr = TestResult.notRun(newTd)) != null) {
            return this.replaceTest(newTr, index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean refreshIfNeeded() {
        if (this.filesToScan != null || this.table != null && this.table.isFinderScanSuppressed() && this.lastScanDate == 0L) {
            File thisDir = new File(TestResultTable.getRootRelativePath(this));
            TestFinder finder = this.table.getTestFinder();
            File[] files = null;
            long thisScanDate = this.table.getLastModifiedTime(thisDir);
            if (thisScanDate <= this.lastScanDate) {
                return false;
            }
            TestFinder testFinder = finder;
            synchronized (testFinder) {
                finder.read(thisDir);
                File[] tmp = finder.getFiles();
                files = new File[tmp.length];
                System.arraycopy(tmp, 0, files, 0, tmp.length);
            }
            long cachedScanDate = this.lastScanDate;
            this.lastScanDate = thisScanDate;
            ArrayList<TestResultTable.TreeNode> nodesUsed = new ArrayList<TestResultTable.TreeNode>();
            ArrayList<TestResult> usedTests = new ArrayList<TestResult>();
            for (int i = 0; i < files.length; ++i) {
                if (this.table.isBranchFile(files[i])) {
                    nodesUsed.add(this.updateDirectory(files[i]));
                    continue;
                }
                if (this.table.getLastModifiedTime(files[i]) <= cachedScanDate) continue;
                usedTests.addAll(this.updateFile(files[i]));
            }
            TestResultTable.TreeNode[] origNodes = this.getTreeNodes();
            if (origNodes != null && origNodes.length != 0) {
                for (TestResultTable.TreeNode n : nodesUsed) {
                    for (int j = 0; j < origNodes.length; ++j) {
                        if (origNodes[j] != n) continue;
                        origNodes[j] = null;
                    }
                }
                for (int i = 0; i < origNodes.length; ++i) {
                    if (origNodes[i] == null) continue;
                    this.rmChild((TRT_TreeNode)origNodes[i]);
                }
            }
            origNodes = null;
            nodesUsed = null;
            TestResult[] currTests = this.getTestResults();
            if (currTests != null && currTests.length != 0) {
                for (TestResult t : usedTests) {
                    for (int j = 0; j < currTests.length; ++j) {
                        if (currTests[j] != t) continue;
                        currTests[j] = null;
                    }
                }
                for (int i = 0; i < currTests.length; ++i) {
                    if (currTests[i] == null || this.rmChild(currTests[i]) == -1) continue;
                    this.table.notifyRemoveLeaf(TestResultTable.getObjectPath(this), currTests[i], i);
                }
            }
            currTests = null;
            usedTests = null;
        } else if (debug > 0) {
            Debug.println("nothing to refresh in " + this.getName());
        }
        return true;
    }

    synchronized TestResult refreshIfNeeded(TestResult test) {
        TestResult result = null;
        try {
            TestDescription oldTd = test.getDescription();
            TestDescription newTd = this.updateTestDescription(test.getTestName(), oldTd);
            if (oldTd == newTd) {
                result = test;
            } else {
                TestResult newTr = TestResult.notRun(newTd);
                if (newTr != null) {
                    this.addChild(newTr, false);
                    result = newTr;
                }
            }
        }
        catch (TestResult.Fault f) {
            if (debug > 0) {
                f.printStackTrace(Debug.getWriter());
            }
            result = test;
        }
        return result;
    }

    synchronized TestResultTable.TreeNode updateDirectory(File f) {
        TestResultTable.TreeNode theNode;
        block7: {
            TestResultTable.TreeNode[] nodes = this.getTreeNodes();
            String dirName = this.makeNodeRelative(f);
            boolean found = false;
            theNode = null;
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    if (!nodes[i].getName().equals(dirName)) continue;
                    found = true;
                    theNode = nodes[i];
                    break;
                }
            } else {
                found = false;
            }
            if (!found) {
                try {
                    TRT_TreeNode newNode = this.createDirNode(this, dirName);
                    int thisIndex = this.getIndex(newNode);
                    this.notifyInsBranch(newNode, thisIndex);
                    TestResultTable.TreeNode[] fullPath = TestResultTable.getObjectPath(newNode);
                    TestResultTable.TreeNode[] modPath = new TRT_TreeNode[fullPath.length - 1];
                    System.arraycopy(fullPath, 0, modPath, 0, fullPath.length - 1);
                    this.table.notifyNewBranch(modPath, newNode, thisIndex);
                    newNode.scanIfNeeded();
                    theNode = newNode;
                }
                catch (Fault e) {
                    if (debug <= 0) break block7;
                    e.printStackTrace(Debug.getWriter());
                }
            }
        }
        return theNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ArrayList<TestResult> updateFile(File fileToScan) {
        ArrayList<TestResult> result = new ArrayList<TestResult>();
        if (debug > 1) {
            System.out.println("Updating file " + fileToScan.getPath());
        }
        TestFinder finder = this.table.getTestFinder();
        TestDescription[] tds = null;
        TestFinder testFinder = finder;
        synchronized (testFinder) {
            finder.read(fileToScan);
            TestDescription[] tds_tmp = finder.getTests();
            tds = new TestDescription[tds_tmp.length];
            System.arraycopy(tds_tmp, 0, tds, 0, tds_tmp.length);
        }
        for (int i = 0; i < tds.length; ++i) {
            TestResult tr = this.getTestResult(tds[i].getRootRelativeURL());
            TestDescription oldTd = null;
            try {
                if (tr != null) {
                    oldTd = tr.getDescription();
                }
            }
            catch (TestResult.Fault f) {
                // empty catch block
            }
            if (tr == null || oldTd == null || !tds[i].equals(oldTd)) {
                TestResult tmpTr;
                TestResult newTr = TestResult.notRun(tds[i]);
                if (tr == null && oldTd == null && (tmpTr = this.table.getCachedResult(tds[i])) != null) {
                    newTr = tmpTr;
                }
                this.table.update(newTr, false);
                if (debug > 1) {
                    System.out.println("New test added");
                }
                TestResultTable.TreeNode[] pathToHere = TestResultTable.getObjectPath(this);
                int index = this.getTestIndex(newTr, false);
                if (tr == null) {
                    this.table.notifyNewLeaf(pathToHere, newTr, index);
                } else {
                    this.table.notifyRemoveLeaf(pathToHere, tr, index);
                    this.table.notifyNewLeaf(pathToHere, newTr, index);
                }
                result.add(newTr);
                continue;
            }
            result.add(tr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized TestDescription updateTestDescription(String url, TestDescription oldTd) {
        String name = url;
        if (name == null && oldTd == null) {
            throw new NullPointerException("both arguments cannot be null");
        }
        if (name == null) {
            name = oldTd.getRootRelativeURL();
        }
        String filename = null;
        int lastSlash = name.lastIndexOf(47);
        int lastHash = name.lastIndexOf(35);
        TestDescription possibleNew = null;
        filename = lastHash > lastSlash ? name.substring(0, lastHash) : name;
        File fileToScan = new File(filename);
        if (this.table.getLastModifiedTime(fileToScan) > this.lastScanDate || oldTd == null) {
            TestFinder finder;
            TestFinder testFinder = finder = this.table.getTestFinder();
            synchronized (testFinder) {
                finder.read(fileToScan);
                TestDescription[] tds = finder.getTests();
                for (int i = 0; i < tds.length; ++i) {
                    if (!tds[i].getRootRelativeURL().equals(name)) continue;
                    possibleNew = tds[i];
                    break;
                }
            }
        }
        if (possibleNew == null) {
            return oldTd;
        }
        if (oldTd == null || !oldTd.equals(possibleNew)) {
            return possibleNew;
        }
        return oldTd;
    }

    private TestResult replaceTest(TestResult newTr, int index) {
        TestResult oldTr = (TestResult)this.childs[index];
        this.childs[index] = newTr;
        this.notifyReplacedResult(oldTr, newTr, index);
        newTr.setParent(this);
        oldTr.setParent(null);
        return newTr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<TestResult> processFile(File file) {
        TestFinder tf;
        if (debug > 0) {
            Debug.println("--- Entering processFile() ---");
            Debug.println("This node's name: " + TestResultTable.getRootRelativePath(this));
            Debug.println("Processing file : " + file.getPath());
        }
        ArrayList<TestResult> result = new ArrayList<TestResult>();
        TestDescription[] tds = null;
        File[] files = null;
        TestFinder testFinder = tf = this.table.getTestFinder();
        synchronized (testFinder) {
            tf.read(file);
            TestDescription[] tds_tmp = tf.getTests();
            File[] files_tmp = tf.getFiles();
            if (tds_tmp != null && tds_tmp.length != 0) {
                tds = new TestDescription[tds_tmp.length];
                System.arraycopy(tds_tmp, 0, tds, 0, tds_tmp.length);
            } else {
                tds = new TestDescription[]{};
            }
            if (files_tmp != null && files_tmp.length != 0) {
                files = new File[files_tmp.length];
                System.arraycopy(files_tmp, 0, files, 0, files_tmp.length);
            } else {
                files = new File[]{};
            }
            if (debug > 0) {
                Debug.println("Read " + tds.length + " tests, and " + files.length + " files.");
            }
        }
        for (TestDescription td : tds) {
            TestResult tr = this.table.getCachedResult(td);
            if (tr == null) {
                tr = TestResult.notRun(td);
            }
            result.add(this.addChild(tr, true));
        }
        if (debug > 0) {
            Debug.println("processFile() done scanning, now inserting");
        }
        this.insertFinderFiles(this, files);
        return result;
    }

    private synchronized void insertFinderFiles(TRT_TreeNode node, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (debug > 1) {
                Debug.print("   => into ");
                Debug.println(node.getName());
                Debug.print("   => original file is: ");
                Debug.println(files[i].getPath());
            }
            String url = this.makeNodeRelative(files[i]);
            if (debug > 1) {
                Debug.println("   => stripped file is: " + url);
            }
            if (url.charAt(url.length() - 1) == '/') {
                url = url.substring(0, url.length() - 1);
            }
            if (url.indexOf(47) == -1) {
                if (this.getEnclosingTable().isBranchFile(files[i])) {
                    if (debug > 1) {
                        Debug.println("   => directory, creating node");
                    }
                    try {
                        TRT_TreeNode newNode = this.createDirNode(node, url);
                    }
                    catch (Fault f) {
                        throw new JavaTestError(i18n, "trttn.nameClash", f);
                    }
                } else {
                    if (debug > 1) {
                        Debug.println("   => file, adding to scan list");
                    }
                    TRT_TreeNode.addToScanList(this, url, files[i]);
                }
            } else {
                this.recursiveFinderInsert(this, files[i], url);
            }
            if (debug <= 1) continue;
            Debug.println("**");
        }
    }

    private synchronized void recursiveFinderInsert(TRT_TreeNode node, File fullFile, String url) {
        String newPath;
        if (debug > 0) {
            Debug.println("Recursive insert: " + url + " into " + node.getName());
        }
        if (url == (newPath = TestResultTable.behead(url))) {
            if (this.getEnclosingTable().isBranchFile(fullFile)) {
                if (debug > 0) {
                    Debug.println("    -> Creating empty node and leaving.");
                }
                TRT_TreeNode newNode = new TRT_TreeNode(this.table, node);
                newNode.setName(newPath);
                node.addChild(newNode, false);
            } else {
                TRT_TreeNode.addToScanList(node, url, fullFile);
            }
        } else {
            String newName = TestResultTable.getDirName(url);
            try {
                TRT_TreeNode newNode = this.createDirNode(node, newName);
                this.recursiveFinderInsert(newNode, fullFile, newPath);
            }
            catch (Fault f) {
                throw new JavaTestError(i18n, "trttn.nameClash", f);
            }
        }
    }

    private TRT_TreeNode createDirNode(TRT_TreeNode parent, String name) throws Fault {
        if (debug > 1) {
            Debug.println("   => Trying to create dir node for: " + name);
        }
        int possibleTR = parent.getResultIndex(name, true);
        if (debug > 1) {
            Debug.println("   => TR index in parent: " + possibleTR);
        }
        if (possibleTR != -1) {
            throw new Fault(i18n, "trttn.alreadyExists", name);
        }
        int location = parent.getNodeIndex(name, true);
        TRT_TreeNode theNode = null;
        if (debug > 1) {
            Debug.println("   => index in parent: " + location);
        }
        if (location == -1) {
            if (debug > 1) {
                Debug.println("   => Creating " + name);
                Debug.println("   => Local node is : " + parent);
            }
            theNode = new TRT_TreeNode(this.table, parent);
            theNode.setName(name);
            if (debug > 1) {
                Debug.println("   => New child node is : " + theNode);
            }
            TRT_TreeNode.addToScanList(theNode, theNode.name, new File(name));
            parent.addChild(theNode, true);
        } else {
            if (debug > 1) {
                Debug.println("   => Node exists, delegating.");
                Debug.println("   => index " + location + " in node " + parent.getName());
            }
            try {
                theNode = (TRT_TreeNode)parent.getChild(location, true);
                if (debug > 1) {
                    Debug.println("   => " + theNode);
                }
            }
            catch (ClassCastException e) {
                throw new JavaTestError(i18n, "trttn.unexpecCast", e);
            }
        }
        return theNode;
    }

    void scanSubtree(TRT_TreeNode node) {
        if (this.table.getTestFinder() == null) {
            return;
        }
        node.scanIfNeeded();
        TRT_TreeNode[] children = (TRT_TreeNode[])node.getTreeNodes();
        if (children != null && children.length != 0) {
            for (int i = 0; i < children.length; ++i) {
                this.scanSubtree(children[i]);
            }
        }
    }

    private String makeNodeRelative(File file) {
        if (debug > 1) {
            Debug.println("relativizing: " + file.getPath());
        }
        if (file.isAbsolute()) {
            int distToDel = this.getTestSuitePathLen();
            if (debug > 1) {
                Debug.println("  -> URL is absolute (" + file.getPath().length() + " chars), stripping.");
                Debug.println("  -> Stripping " + distToDel + " characters.");
            }
            String rrp = TestResultTable.getRootRelativePath(this);
            if (debug > 1) {
                Debug.println("  -> removing rrp: " + rrp);
            }
            String platformPath = file.getPath().substring(distToDel += rrp == null || rrp.length() == 0 ? 0 : rrp.length() + 1);
            if (debug > 1) {
                Debug.println("  -> final node path: " + platformPath);
            }
            return platformPath.replace(File.separatorChar, '/');
        }
        String rrp = TestResultTable.getRootRelativePath(this);
        String thisFilePath = file.getPath().replace(File.separatorChar, '/');
        if (debug > 1) {
            Debug.println("  -> check for RRP against: " + rrp);
        }
        if (rrp != null && rrp.length() != 0 && thisFilePath.startsWith(rrp)) {
            if (debug > 1) {
                Debug.println("  -> URL is root relative, stripping");
            }
            int distToDel = rrp.length() + 1;
            if (thisFilePath.length() > distToDel) {
                return thisFilePath.substring(distToDel);
            }
            return "";
        }
        if (debug > 1) {
            Debug.println("  -> relative, continue");
        }
        return thisFilePath;
    }

    private static void addToScanList(TRT_TreeNode node, String file, File fullFile) {
        if (debug > 1) {
            Debug.println("   => Adding " + file + " to scan list and leaving.");
            Debug.println("   => Local node is : " + node);
            Debug.println("   -> local size b4: " + (node.filesToScan == null ? 0 : node.filesToScan.length));
        }
        int i = 0;
        if (node.filesToScan != null) {
            if (node.filesToScan.length > 0 && node.filesToScan[0].equals(node.getName())) {
                i = 1;
            }
            while (i < node.filesToScan.length && !node.filesToScan[i].equals(file)) {
                ++i;
            }
        }
        if (node.filesToScan == null || i >= node.filesToScan.length) {
            node.filesToScan = (String[])DynamicArray.append(node.filesToScan, file);
        } else if (debug > 1) {
            Debug.println("Warning: File " + fullFile.getPath() + " may be referenced more than once in the test suite.  Ignoring.");
        }
        if (debug > 1) {
            Debug.println("   -> local size after: " + (node.filesToScan == null ? 0 : node.filesToScan.length));
        }
    }

    synchronized TestResult addChild(TestResult tr, boolean suppressScan) {
        return this.addChild(tr, suppressScan, false);
    }

    synchronized TestResult addChild(TestResult tr, boolean suppressScan, boolean drop) {
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        if (tr == null) {
            throw new JavaTestError(i18n, "trttn.nullNode");
        }
        if (debug > 1) {
            Debug.println("Adding test " + tr.getTestName());
            Debug.println("   -> " + tr.getStatus().toString());
            Debug.println("   -> local node ref: " + this);
            Debug.println("   -> local node name: " + this.getName());
            Debug.println("   -> local size: " + (this.childs == null ? 0 : this.childs.length));
        }
        int oldIndex = this.getTestIndex(tr, suppressScan);
        TestResult oldTR = null;
        if (oldIndex == -1) {
            if (drop && this.table.getWorkDirectory() != null) {
                return null;
            }
            if (debug > 1) {
                Debug.println("   -> no old entry for " + tr);
            }
            try {
                this.childs = DynamicArray.append(this.childs, tr, Class.forName("java.lang.Object"));
                tr.setParent(this);
                this.bubbleUpCounterInc();
                this.notifyInsResult(tr, this.childs.length - 1);
            }
            catch (ClassNotFoundException e) {
                throw new JavaTestError(i18n, "trttn.noObject", e);
            }
        } else if (this.shouldReplaceTest(oldIndex, tr, suppressScan)) {
            oldTR = (TestResult)this.childs[oldIndex];
            this.childs[oldIndex] = tr;
            if (debug > 0) {
                Debug.println("   -> ** replacing existing TR with " + tr);
                Debug.println("   -> " + tr.getTestName());
                Debug.println("   -> old status " + oldTR.getStatus().toString());
                Debug.println("   -> node: " + this);
            }
            oldTR.setParent(null);
            tr.setParent(this);
            this.notifyReplacedResult(oldTR, tr, oldIndex);
        } else {
            if (debug > 1) {
                Debug.println("   -> ** TRT selectively ignoring insert of " + tr);
                Debug.println("   -> old status: " + ((TestResult)this.childs[oldIndex]).getStatus().toString());
                Debug.println("   -> curr. ref in TRT: " + this.childs[oldIndex]);
                Debug.println("   -> ignored new ref.: " + tr);
            }
            return tr;
        }
        this.invalidateChildStats();
        return oldTR;
    }

    synchronized void addChild(TRT_TreeNode tn, boolean suppressScan) {
        if (tn == null) {
            throw new JavaTestError(i18n, "trttn.nullNode");
        }
        if (!suppressScan) {
            this.scanIfNeeded();
        }
        try {
            this.childs = DynamicArray.append(this.childs, tn, Class.forName("java.lang.Object"));
        }
        catch (ClassNotFoundException e) {
            throw new JavaTestError(i18n, "trttn.noObject", e);
        }
    }

    synchronized int rmChild(TRT_TreeNode tn) {
        if (this.childs == null) {
            throw new IllegalStateException("Node is empty!");
        }
        for (int i = 0; i < this.childs.length; ++i) {
            if (this.childs[i] != tn) continue;
            Object[] newarr = DynamicArray.remove(this.childs, i);
            this.childs = newarr == null ? new Object[]{} : newarr;
            this.invalidateChildStats();
            this.notifyRemovedBranch(i);
            this.getEnclosingTable().notifyRemoveLeaf(TestResultTable.getObjectPath(this), tn, i);
            return i;
        }
        return -1;
    }

    synchronized int rmChild(TestResult tr) {
        if (this.childs == null) {
            throw new IllegalStateException("Node is empty!");
        }
        for (int i = 0; i < this.childs.length; ++i) {
            if (this.childs[i] != tr) continue;
            Object[] newarr = DynamicArray.remove(this.childs, i);
            this.childs = newarr == null ? new Object[]{} : newarr;
            this.invalidateChildStats();
            this.notifyRemovedResult(tr, i);
            return i;
        }
        return -1;
    }

    void setName(String name) {
        this.name = name;
    }

    private boolean shouldReplaceTest(int index, TestResult newone, boolean suppressScan) {
        if (!(this.childs[index] instanceof TestResult) || newone == null || index < 0 || index >= this.childs.length) {
            return false;
        }
        TestResult orig = (TestResult)this.childs[index];
        if (!orig.getTestName().equals(newone.getTestName())) {
            return false;
        }
        if (this.table != null && this.table.getWorkDirectory() != null && this.table.getWorkDirectory().getTestSuite() != null && this.table.getWorkDirectory().getTestSuite().getTestRefreshBehavior(2)) {
            try {
                TestDescription tdnew = newone.getDescription();
                TestDescription tdcurr = orig.getDescription();
                if (tdnew == null && tdcurr != null) {
                    return false;
                }
                if (tdnew != null && tdcurr == null) {
                    return true;
                }
                if (!(tdnew == null && tdcurr == null || tdnew.equals(tdcurr))) {
                    return false;
                }
            }
            catch (TestResult.Fault f) {
                // empty catch block
            }
        }
        Status newstat = newone.getStatus();
        Status oldstat = orig.getStatus();
        if (newstat.getType() == 3 && oldstat.getType() != 3) {
            return false;
        }
        if (oldstat.getType() != newstat.getType()) {
            return true;
        }
        if (!oldstat.getReason().equals(newstat.getReason())) {
            return true;
        }
        boolean oldShrunk = orig.isShrunk();
        boolean newShrunk = newone.isShrunk();
        if (oldShrunk && !newShrunk) {
            return true;
        }
        return !oldShrunk && !newShrunk;
    }

    private static void refreshChildStats(TRT_TreeNode node) {
        if (node.childStats != null) {
            return;
        }
        node.childStats = new int[4];
        for (int i = 0; i < node.childs.length; ++i) {
            if (node.childs[i] instanceof TRT_TreeNode) {
                TRT_TreeNode child = (TRT_TreeNode)node.childs[i];
                int[] stats = child.getChildStatus();
                for (int j = 0; j < stats.length; ++j) {
                    int n = j;
                    node.childStats[n] = node.childStats[n] + stats[j];
                }
                continue;
            }
            TestResult tr = (TestResult)node.childs[i];
            int n = tr.getStatus().getType();
            node.childStats[n] = node.childStats[n] + 1;
        }
    }

    void bubbleUpCounterInc() {
        ++this.counter;
        this.notifyCounterChange();
        TRT_TreeNode parent = (TRT_TreeNode)this.getParent();
        if (parent != null) {
            parent.bubbleUpCounterInc();
        }
    }

    private int getTestSuitePathLen() {
        if (this.table.getTestSuiteRoot().isFile()) {
            return this.table.getTestSuiteRoot().getParent().length() + 1;
        }
        return this.table.getTestSuiteRoot().getAbsolutePath().length() + 1;
    }

    private File getTestSuiteRootPathPrefix() {
        File tsr = this.table.getTestSuiteRoot();
        if (tsr.isFile()) {
            return tsr.getParentFile();
        }
        return tsr;
    }

    private void notifyInsBranch(TRT_TreeNode newNode, int index) {
        TestResultTable.TreeNodeObserver[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].insertedBranch(this, newNode, index);
            }
        }
    }

    private void notifyInsResult(TestResult test, int index) {
        TestResultTable.TreeNodeObserver[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].insertedResult(this, test, index);
            }
        }
    }

    private void notifyReplacedResult(TestResult oldTest, TestResult newTest, int index) {
        TestResultTable.TreeNodeObserver[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].replacedResult(this, oldTest, newTest, index);
            }
        }
    }

    private void notifyRemovedBranch(int index) {
        TestResultTable.TreeNodeObserver[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].removedBranch(this, index);
            }
        }
    }

    private void notifyRemovedResult(TestResult test, int index) {
        TestResultTable.TreeNodeObserver[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].removedResult(this, test, index);
            }
        }
    }

    private void notifyCounterChange() {
        TestResultTable.TreeNodeObserver[] observers = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].countersInvalidated(this);
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }
}

