/*
 * Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

// $Id: ObjectBuilder.java 74753 2016-12-19 11:13:34Z tkraus $
/**
 * {@link JsonObjectBuilder} manipulation helper.
 */
public class ObjectBuilder {
    
    /**
     * Add {@code value} with {@code name} to provided JSON object builder.
     * @param builder Target JSON object builder.
     * @param name Name of value to be added.
     * @param value Value to be added.
     * @return JSON object builder containing new {@code value}.
     */
    @SuppressWarnings("UnnecessaryUnboxing")
    public static JsonObjectBuilder add(final JsonObjectBuilder builder, final String name, final Object value) {
        switch (JsonValueType.getType(value)) {
            case String:
                return builder.add(name, (String)value);
            case Integer:
                return builder.add(name, ((Integer)value).intValue());
            case Long:
                return builder.add(name, ((Long)value).intValue());
            case BigInteger:
                return builder.add(name, ((BigInteger)value));
            case Double:
                return builder.add(name, ((Double)value).doubleValue());
            case BigDecimal:
                return builder.add(name, ((BigDecimal)value));
            case Boolean:
                return builder.add(name, ((Boolean)value).booleanValue());
            case JsonValue:
                return builder.add(name, (JsonValue)value);
            case Null:
                return builder.addNull(name);
            default:
                throw new IllegalArgumentException("Value does not match known JSON value type");
        }       
    }

}
