/*
 * Copyright (c) 2017 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.collectortests;

import com.sun.ts.tests.jsonp.api.common.JsonPTest;
import com.sun.ts.tests.jsonp.api.common.TestResult;

// $Id: CollectorTests.java 74768 2017-01-10 11:03:37Z tkraus $
/**
 * JavaScript Object Notation (JSON) Pointer compatibility tests.<br>
 * Test {@link javax.json.stream.JsonCollectors} class implementation.
 */
public class CollectorTests extends JsonPTest {
    
    /**
     * Test JSON-P {@link javax.json.stream.JsonCollectors} class implementation.
     * @throws Fault when this test failed.

     * @testName:      jsonCollectorTest
     * @assertion_ids: JSONP:JAVADOC:668; JSONP:JAVADOC:669; JSONP:JAVADOC:670; JSONP:JAVADOC:671;
     * @test_Strategy: Test all collectors returned by API.
     */
    public void jsonCollectorTest() throws Fault {
        Collectors collectorTest = new Collectors();
        final TestResult result = collectorTest.test();
        result.eval();
    }
}
