/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
/*
 * $Id: Team.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.relationship.annotations;

import javax.persistence.*;

/*
 * Team
 */

@Entity
public class Team implements java.io.Serializable {

    // Instance variables
    private int  teamid;
    private String  name;
    private Company company;

    public Team() {
    }

    public Team(int teamid, String name) {
        this.teamid = teamid;
        this.name = name;
    }


    // ===========================================================
    // getters and setters for the state fields

    @Id
    public int getTeamId() {
        return teamid;
    }
    public void setTeamId(int teamid) {
        this.teamid = teamid;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    // ===========================================================
    // getters and setters for the association fields


    /* Bi-Directional Many(Teams)ToOne(Company)  - Owner Team */
    @ManyToOne(cascade=CascadeType.REMOVE)
    @JoinColumn(name="COMPANY_COMPANYID")
    public Company getCompany() {
        return company;
    }
    public void setCompany(Company company) {
        this.company = company;
    }

}

