/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex4a;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class DID4MedicalHistory implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @OneToOne
    @JoinColumn(name="PATIENT_SSN")
    private DID4Person patient;
    private String doctorName;

    public DID4MedicalHistory() {
    }

    public DID4MedicalHistory(DID4Person patient, String doctorName) {
        this.patient = patient;
        this.doctorName = doctorName;
    }

    public DID4Person getPatient() {
        return patient;
    }

    public void setPatient(DID4Person patient) {
        this.patient = patient;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (patient != null ? patient.hashCode() : 0);
        return hash;
    }

    public String getDoctorName() {
        return doctorName;
    }

    public void setDoctorName(String doctorName) {
        this.doctorName = doctorName;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DID4MedicalHistory)) {
            return false;
        }
        DID4MedicalHistory other = (DID4MedicalHistory) object;
        if ((this.patient == null && other.patient != null) || (this.patient != null && !this.patient.equals(other.patient))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "derivedpatient4.DID4MedicalHistory[patient=" + patient + "]";
    }
}
