/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.annotations.ordercolumn;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name="DEPARTMENT")
@Access(AccessType.FIELD)
public class Department2 implements java.io.Serializable {

    @Id
    @Column(name="ID")
    private int  id;

    @Column(name="NAME")
    private String  name;

    @OneToMany(mappedBy="department")
    @OrderColumn()
    private List<Employee2> employees;

    public Department2() {
    }

    public Department2(int id, String name) {
        this.id = id;
        this.name = name;
    }


    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }


    public List <Employee2> getEmployees() {
        return employees;
    }
    public void setEmployees(List<Employee2> employees) {
        this.employees = employees;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName()+"[");
        result.append("id: " + getId());
        result.append(", first: " + getName());
        result.append("]");
        return result.toString();
    }
    public boolean equals(Object o) {
        Department2 other;
        boolean result = false;

        if (!(o instanceof Department2)) {
            return result;
        }
        other = (Department2) o;

        if (this.getId() == other.getId() &&
                this.getName().equals(other.getName())
                ) {
            result = true;
        }

        return result;
    }


    public int hashCode() {
        int myHash;

        myHash = this.getId() + this.getName().hashCode();

        return myHash;
    }
}
