/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigInteger;

@Entity
@Table(name = "DATATYPES3")
public class PropertyBigIntegerId implements java.io.Serializable {

    // ===========================================================
    // instance variables


    protected BigInteger id;

    private BigInteger bigInteger;


    // ===========================================================
    // constructors
    public PropertyBigIntegerId() {
    }

    public PropertyBigIntegerId(BigInteger id, BigInteger bigInteger) {

        this.id = id;
        this.bigInteger = bigInteger;

    }


    @Id
    @Column(name = "ID")
    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    @Column(name = "THEVALUE")
    public BigInteger getBigInteger() {
        return this.bigInteger;
    }

    public void setBigInteger(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         if (getBigInteger() != null){
             result.append(", BigInteger: " + getBigInteger());
         } else {
             result.append(", BigInteger: null");
         }
         result.append("]");
         return result.toString();
     }
}
