/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */


package com.sun.ts.tests.jpa.core.annotations.access.field;

import javax.persistence.*;

@Entity
@Table(name = "DATATYPES2")
@Access(AccessType.FIELD)
public class DataTypes2 implements java.io.Serializable {
    @Id
    @Column(name = "DATATYPES2_ID")
    @Temporal(TemporalType.DATE)
    protected java.util.Date id;

    @Column(name = "DATEDATA")
    @Temporal(TemporalType.DATE)
    protected java.util.Date dateData;

    @Column(name = "TIMEDATA")
    protected java.sql.Time timeData;

    @Column(name = "TSDATA")
    protected java.sql.Timestamp tsData;


    public DataTypes2() {
    }


    public DataTypes2(java.util.Date id) {
        this.id = id;

    }
    public DataTypes2(java.util.Date id, java.sql.Time timeData,
                      java.sql.Timestamp tsData) {
        this.id = id;
        this.timeData = timeData;
        this.tsData = tsData;
    }

    public java.util.Date getId() {
        return id;
    }

    public java.util.Date getDateData() {
        return dateData;
    }

    public void setDateData(java.util.Date dateData) {
        this.dateData = dateData;
    }

    public java.sql.Time getTimeData() {
        return timeData;
    }

    public void setTimeData(java.sql.Time timeData) {
        this.timeData = timeData;
    }

    public java.sql.Timestamp getTsData() {
        return tsData;
    }

    public void setTsData(java.sql.Timestamp tsData) {
        this.tsData = tsData;
    }


    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getDateData() != null) {
            result.append(", DateData: " + getDateData());
        } else {
            result.append(", DateData: null");
        }
        if (getTimeData() != null) {
            result.append(", TimeData: " + getTimeData());
        } else {
            result.append(", TimeData: null");
        }
        if (getTsData() != null) {
            result.append(", Timestamp: " + getTsData());
        } else {
            result.append(", Timestamp: null");
        }
        result.append("]");
        return result.toString();
    }
}