/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyMessageListener.java 69201 2012-12-18 17:34:13Z af70133 $
 */
package com.sun.ts.tests.jms.core20.appclient.messageconsumertests;

import com.sun.ts.lib.util.TestUtil;
import javax.jms.Message;
import javax.jms.MessageListener;

public class MyMessageListener implements MessageListener {

    private String name = null;
    private Message message = null;
    boolean complete = false;

    public MyMessageListener() { this("MyMessageListener"); }
    public MyMessageListener(String name) { this.name = name; }

    // getters/setters
    public String getName() { return name; }
    public void setName(String name) { this.name = name; }
    public Message getMessage() { return message; }
    public void setMessage(Message message) { this.message = message; }
    public boolean isComplete() { return complete; }
    public void setComplete(boolean complete) { this.complete = complete; }

    public void onMessage(Message message) {
	TestUtil.logMsg("Got Message: " + message);
	this.message = message;
	complete = true;
    }

}
