/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AbstractReader.java 71674 2013-04-22 09:13:23Z supol $  
 */
package com.sun.ts.tests.jaxrs.spec.provider.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

public abstract class AbstractReader implements
		MessageBodyReader<EntityForReader> {

	static StringBuilder readerSet = new StringBuilder();
	public static final MediaType NO_PROVIDER_MEDIATYPE = new MediaType("abc", "def");

	public static void resetSet() {
		readerSet = new StringBuilder();
	}

	public static void addClass(String string) {
		readerSet.append(string).append(";");
	}

	@Override
	public EntityForReader readFrom(Class<EntityForReader> type,
			Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		InputStreamReader isr = new InputStreamReader(entityStream);
		BufferedReader br = new BufferedReader(isr);
		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName().toUpperCase()).append(";");
		if (mediaType != null)
			sb.append(mediaType.toString()).append(";");
		sb.append(br.readLine());
		br.close();
		sb.append(";").append(readerSet);		
		return new EntityForReader(sb.toString());
	}
}
