/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AbstractAddFilter.java 69694 2013-01-30 14:54:06Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.globalbinding;

import java.io.IOException;
import java.lang.annotation.Annotation;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;

public abstract class AbstractAddFilter implements ContainerResponseFilter {

	protected int amount;

	public AbstractAddFilter(int amount) {
		this.amount = amount;
	}

	@Override
	public void filter(ContainerRequestContext requestContext,
			ContainerResponseContext responseContext) throws IOException {
		int status = responseContext.getStatus();
		if (status != 500) {
			String entity = (String) responseContext.getEntity();
			Integer i = Integer.valueOf(entity);
			entity = String.valueOf(i + amount);
			responseContext.setEntity(entity, (Annotation[]) null,
					MediaType.WILDCARD_TYPE);
		}
	}

}
