/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;

public class InterfaceAdapter
implements Cloneable,
Callable {
    private Function function;
    private Class nonPrimitiveResultClass;
    private int[] argsToConvert;

    public static InterfaceAdapter create(Class cl, Function f) {
        ClassCache cache = ClassCache.get(f);
        InterfaceAdapter master = (InterfaceAdapter)cache.getInterfaceAdapter(cl);
        if (master == null) {
            if (!cl.isInterface()) {
                return null;
            }
            Method[] methods = cl.getMethods();
            if (methods.length == 0) {
                return null;
            }
            Class<?> returnType = methods[0].getReturnType();
            Class[] argTypes = methods[0].getParameterTypes();
            for (int i = 1; i != methods.length; ++i) {
                if (returnType != methods[i].getReturnType()) {
                    return null;
                }
                Class<?>[] types2 = methods[i].getParameterTypes();
                if (types2.length != argTypes.length) {
                    return null;
                }
                for (int j = 0; j != argTypes.length; ++j) {
                    if (types2[j] == argTypes[j]) continue;
                    return null;
                }
            }
            String className = "iadapter" + cache.newClassSerialNumber();
            byte[] code = InterfaceAdapter.createCode(cl, methods, returnType, argTypes, className);
            Class iadapterClass = JavaAdapter.loadAdapterClass(className, code);
            try {
                master = (InterfaceAdapter)iadapterClass.newInstance();
            }
            catch (Exception ex) {
                throw Context.throwAsScriptRuntimeEx(ex);
            }
            master.initMaster(returnType, argTypes);
            cache.cacheInterfaceAdapter(cl, master);
        }
        return master.wrap(f);
    }

    private static byte[] createCode(Class interfaceClass, Method[] methods, Class returnType, Class[] argTypes, String className) {
        String superName = "org.mozilla.javascript.InterfaceAdapter";
        ClassFileWriter cfw = new ClassFileWriter(className, superName, "<ifglue>");
        cfw.addInterface(interfaceClass.getName());
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(177);
        cfw.stopMethod((short)1);
        for (int i = 0; i != methods.length; ++i) {
            Method method = methods[i];
            StringBuffer sb = new StringBuffer();
            int localsEnd = JavaAdapter.appendMethodSignature(argTypes, returnType, sb);
            String methodSignature = sb.toString();
            cfw.startMethod(method.getName(), methodSignature, (short)1);
            cfw.addLoadThis();
            JavaAdapter.generatePushWrappedArgs(cfw, argTypes, argTypes.length + 1);
            cfw.add(89);
            cfw.addPush(argTypes.length);
            cfw.addPush(method.getName());
            cfw.add(83);
            cfw.addInvoke(183, superName, "doCall", "([Ljava/lang/Object;)Ljava/lang/Object;");
            JavaAdapter.generateReturnResult(cfw, returnType, false);
            cfw.stopMethod((short)localsEnd);
        }
        return cfw.toByteArray();
    }

    private void initMaster(Class returnType, Class[] argTypes) {
        if (this.function != null) {
            Kit.codeBug();
        }
        if (!returnType.isPrimitive()) {
            this.nonPrimitiveResultClass = returnType;
        }
        this.argsToConvert = JavaAdapter.getArgsToConvert(argTypes);
    }

    private InterfaceAdapter wrap(Function function) {
        InterfaceAdapter copy;
        if (function == null) {
            Kit.codeBug();
        }
        if (this.function != null) {
            Kit.codeBug();
        }
        try {
            copy = (InterfaceAdapter)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            copy = null;
        }
        copy.function = function;
        return copy;
    }

    protected final Object doCall(Object[] args) {
        Scriptable scope;
        Scriptable thisObj = scope = this.function.getParentScope();
        Object result = Context.call(null, this, scope, thisObj, args);
        if (this.nonPrimitiveResultClass != null) {
            result = result == Undefined.instance ? null : NativeJavaObject.coerceType(this.nonPrimitiveResultClass, result, true);
        }
        return result;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.argsToConvert != null) {
            WrapFactory wf = cx.getWrapFactory();
            int N = this.argsToConvert.length;
            for (int i = 0; i != N; ++i) {
                int index = this.argsToConvert[i];
                Object arg = args[index];
                if (arg == null || arg instanceof Scriptable) continue;
                args[index] = wf.wrap(cx, scope, arg, null);
            }
        }
        return this.function.call(cx, scope, thisObj, args);
    }
}

