/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlInput
extends ClickableElement
implements DisabledElement,
SubmittableElement {
    public static final String TAG_NAME = "input";
    private String defaultValue_ = this.getValueAttribute();

    public HtmlInput(SgmlPage page, Map<String, DomAttr> attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    public HtmlInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public Page setValueAttribute(String newValue) {
        WebAssert.notNull("newValue", newValue);
        this.setAttributeValue("value", newValue);
        return HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    @Override
    public String asText() {
        return this.getValueAttribute();
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeValue("value");
    }

    public final String getCheckedAttribute() {
        return this.getAttributeValue("checked");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttributeValue("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttributeValue("maxlength");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getAltAttribute() {
        return this.getAttributeValue("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeValue("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttributeValue("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    @Override
    public void reset() {
        this.setValueAttribute(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getPage().getWebClient().getBrowserVersion().isNetscape();
        this.setDefaultValue(defaultValue, modifyValue);
    }

    protected void setDefaultValue(String defaultValue, boolean modifyValue) {
        this.defaultValue_ = defaultValue;
        if (modifyValue) {
            this.setValueAttribute(defaultValue);
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public Page setChecked(boolean isChecked) {
        return this.getPage();
    }

    public boolean isChecked() {
        return this.isAttributeDefined("checked");
    }

    public Page click(int x, int y) throws IOException, ElementNotFoundException {
        return this.click();
    }

    static Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        SgmlPage page = htmlElement.getPage();
        JavaScriptEngine engine = htmlElement.getPage().getWebClient().getJavaScriptEngine();
        if (engine.isScriptRunning()) {
            return page;
        }
        ScriptResult scriptResult = htmlElement.fireEvent("change");
        if (page.getWebClient().getWebWindows().contains(page.getEnclosingWindow())) {
            return page.getEnclosingWindow().getEnclosedPage();
        }
        if (scriptResult != null) {
            return scriptResult.getNewPage();
        }
        return page;
    }
}

