 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: EjbLinkBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.ejblink;

import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;

abstract public class EjbLinkBeanBase implements EjbLinkIF {
    public void call() throws TestFailedException {
    }
    
    
    public void localCall(int[] f) throws TestFailedException {
        f[0] = 1;
    }
    
    public void callOneLocal() throws TestFailedException {
        EjbLinkLocalIF localBean1 = (EjbLinkLocalIF) ServiceLocator.lookupNoTry(Constants.BEAN1_LOCAL_REF_NAME);
        int[] f = new int[] {0};
        int expected = 1;
        localBean1.localCall(f);
        if(f[0] != expected) {
            throw new TestFailedException("Expecting " + expected + ", but got " + f[0]);
        }
    }
    
}
