/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Constants.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

public final class Constants {

    private Constants(){} // no instances

    public static final String NL                                = System.getProperty("line.separator", "\n");
    public static final String TEMP_DIR                          = System.getProperty("java.io.tmpdir");

    // Constants for the bootstrap, component and service unit manager lifecycle tests
    public static final String BC_START_LIFECYCLE_RESULT_FILE    = "bc-lifecycle-start-result.ser";
    public static final String BC_STOP_LIFECYCLE_RESULT_FILE     = "bc-lifecycle-stop-result.ser";
    public static final String BC_BS_START_LIFECYCLE_RESULT_FILE = "bc-bs-lifecycle-start-result.ser"; 
    public static final String BC_BS_STOP_LIFECYCLE_RESULT_FILE  = "bc-bs-lifecycle-stop-result.ser"; 
    public static final String SE_START_LIFECYCLE_RESULT_FILE    = "se-lifecycle-start-result.ser";
    public static final String SE_STOP_LIFECYCLE_RESULT_FILE     = "se-lifecycle-stop-result.ser";
    public static final String SE_BS_START_LIFECYCLE_RESULT_FILE = "se-bs-lifecycle-start-result.ser"; 
    public static final String SE_BS_STOP_LIFECYCLE_RESULT_FILE  = "se-bs-lifecycle-stop-result.ser"; 
    public static final String SE_DEPLOY_LIFECYCLE_RESULT_FILE   = "se-lifecycle-deploy-result.ser"; 
    public static final String SE_UNDEPLOY_LIFECYCLE_RESULT_FILE = "se-lifecycle-undeploy-result.ser"; 
    public static final String BC_DEPLOY_LIFECYCLE_RESULT_FILE   = "bc-lifecycle-deploy-result.ser"; 
    public static final String BC_UNDEPLOY_LIFECYCLE_RESULT_FILE = "bc-lifecycle-undeploy-result.ser"; 

    // Names associated to the RMI host and port values.  These names are used in both a props
    // file that saves the values to a disk file as well as in a JNDI naming service.
    public static final String RMI_PORT_NAME = "RmiPort";
    public static final String RMI_HOST_NAME = "RmiHost";
    public static final String RMI_BIND_NAME = "RmiBindName";

    // InstallationContext API test result filenames
    public static final String INSTALL_CONTEXT_CLASS_PATH_ELEMENTS_FILE      = "getClassPathElementsTest.ser";
    public static final String INSTALL_CONTEXT_COMPONENT_CLASS_NAME_FILE     = "getComponentClassNameTest.ser";
    public static final String INSTALL_CONTEXT_COMPONENT_NAME_FILE           = "getComponentNameTest.ser";
    public static final String INSTALL_CONTEXT_CONTEXT_FILE                  = "getContextTest.ser";
    public static final String INSTALL_CONTEXT_INSTALL_DESC_EXT_FILE         = "getInstallationDescriptorExtensionTest.ser";
    public static final String INSTALL_CONTEXT_INSTALL_DESC_EXT_NULL_FILE    = "getInstallationDescriptorExtensionTest2.ser";
    public static final String INSTALL_CONTEXT_INSTALL_ROOT_FILE             = "getInstallRootTest.ser";
    public static final String INSTALL_CONTEXT_INSTALL_ROOT2_FILE            = "getInstallRootTest2.ser";
    public static final String INSTALL_CONTEXT_INSTALL_ROOT3_FILE            = "getInstallRootTest3.ser";
    public static final String INSTALL_CONTEXT_IS_INSTALL_FILE               = "isInstallTest.ser";
    public static final String INSTALL_CONTEXT_SET_CLASS_PATH_ELEMENTS_FILE  = "setClassPathElementsTest.ser";

    public static final String SET_CLASSPATH_NULL_FILE                       = "setClassPathNullTest.ser";
    public static final String SET_CLASSPATH_EMPTY_FILE                      = "setClassPathEmptyTest.ser";
    public static final String SET_CLASSPATH_BOGUS_FILE                      = "setClassPathBogusTest.ser";

    public static final String LOAD_CLASS_BOOT_STRAP_DELEGATE_FILE           = "loadClassDelegateTest.ser";
    public static final String LOAD_CLASS_BOOT_STRAP_NON_DELEGATE_FILE       = "loadClassNonDelegateTest.ser";
    public static final String LOAD_JAVAX_CLASS_BOOT_STRAP_NON_DELEGATE_FILE = "loadJavaxClassNonDelegateTest.ser";
    public static final String LOAD_JAVA_CLASS_BOOT_STRAP_NON_DELEGATE_FILE  = "loadJavaClassNonDelegateTest.ser";
    public static final String LOAD_CLASS_BOOT_STRAP_JBI_XML_FILE            = "loadJavaClassJBIXmlTest.ser";
    public static final String LOAD_CLASS_BOOT_STRAP_JBI_XML_FILE2           = "loadJavaClassJBIXmlTest2.ser";
    
    //Service names and Endpoint names
    public static final String UPCASE_SERVICE_NAME  = "tck.upcase.service";
    public static final String UPCASE_ENDPOINT_NAME = "tck.upcase.endpoint";   
    
    
    //Constants used during MEP related tests
    public static final String FAULT              = "fault.string";
    public static final String FAULT_ROBUSTINONLY = "fault.robustinonly.value";
    public static final String RETURN_DONE_PROP   = "return.done.status";
    public static final String RETURN_FAULT_PROP  = "return.fault";
    
    
    
    
    
    /** The XML namespace for WSDL 2.0 documents recognized by this implementation. */
    public static final String WSDL_NAMESPACE_NAME  = 
        "http://www.w3.org/2004/08/wsdl";

    /** In Only MEP. */
    public static final String IN_ONLY = 
                        WSDL_NAMESPACE_NAME + "/in-only";

    /** RobustInOnly MEP. */
    public static final String ROBUST_IN_ONLY = 
                        WSDL_NAMESPACE_NAME + "/robust-in-only";

    /** In Out MEP. */
    public static final String IN_OUT =
                        WSDL_NAMESPACE_NAME + "/in-out";

    /** InOptionalOut MEP. */
    public static final String IN_OPTIONAL_OUT =
                        WSDL_NAMESPACE_NAME + "/in-opt-out";

} // end class Constants
