/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseComponent.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import java.util.*;
import com.sun.ts.lib.util.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import javax.xml.namespace.QName;
import javax.management.ObjectName;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.Component;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.management.DeploymentException;

/*
 * Adapter class for the JBI interfaces: Component, ServiceUnitManager and ComponentLifeCycle.
 * Some of our child components don't need to implement all these methods but only a subset
 * of them.  This class contains default implementations for the child classes to leverage
 * if they choose to.  Child classes can also call super to log the fact that an API has
 * been called.  This keeps all trace type logging in one place.
 */
public class BaseComponent implements Component, ComponentLifeCycle, ServiceUnitManager {

    // All child classes will want to have an instance variable to store the context
    protected ComponentContext ctx;

    // Name used to hold the component class name, used for trace logging
    protected static String NAME;

    // Shared code used by all components in the JBI TCK
    public void testInit(Properties p) throws Exception {
	try {
	    TestUtil.init(p);
	} catch (Exception e) {
	    TestUtil.logErr("testInit failed in JBI Component.", e);
	    throw new Exception();
	}
    }

    public void logMsg(String msg) {
	TestUtil.logMsg(NAME + ": " + msg);
    }

    public void logErr(String msg) {
	TestUtil.logErr(NAME + ": " + msg);
    }

    public void logErr(String msg, Throwable t) {
	TestUtil.logErr(NAME + ": " + msg, t);
    }

    public void logTrace(String msg) {
	TestUtil.logTrace(NAME + ": " + msg);
    }

    public void logTrace(String msg, Throwable t) {
	TestUtil.logTrace(NAME + ": " + msg, t);
    }


    // Component Impl, default empty implementations
    public ComponentLifeCycle getLifeCycle() {
	System.err.println(NAME + ".getLifeCycle() called");
	return this;
    }

    public Document getServiceDescription(ServiceEndpoint ref) {
	System.err.println(NAME + ".getServiceDescription(ServiceEndpoint) called");
	return null;
    }

    public ServiceUnitManager getServiceUnitManager() {
	System.err.println(NAME + ".getServiceUnitManager() called");
	return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint,
					      MessageExchange exchange){
	System.err.println
	    (NAME + ".isExchangeWithConsumerOkay(ServiceEndpoint, MessageExchange) called");
	return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
	System.err.println(NAME + ".isExchangeWithProviderOkay(MessageExchange) called");
	return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
	System.err.println(NAME + ".resolveEndpointReference(DocumentFragment) called");
	return null;
    }


    // ComponentLifeCycle impl, default empty implementations
    public ObjectName getExtensionMBeanName() {
	System.err.println(NAME + ".getExtensionMBeanName() called");
	return null;
    }

    // all child classes should call super.init() since this method can handle the trace log and
    // saving the specified context
    public void init(ComponentContext arg0) throws JBIException {
	ctx = arg0;
	System.err.println(NAME + ".init(ComponentContext) called");
	System.err.println("BindingContext:" + ctx);
    }

    public ObjectName getDeploymentMBeanName() {
	System.err.println(NAME + ".getDeploymentMBeanName() called");
	return null;
    }

    public void start() throws JBIException {
	System.err.println(NAME + ".start() called");
    }

    public void stop() throws JBIException {
	System.err.println(NAME + ".stop() called");
    }

    public void shutDown() throws JBIException {
	System.err.println(NAME + ".shutdown() called");
    }


    // ServiceUnitManager impl
    public String deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException { 
	System.err.println(NAME + ".deploy(String serviceUnitName, String serviceUnitRootPath) called");
	System.err.println("\tserviceUnitName \"" + serviceUnitName + "\"");
	System.err.println("\tserviceUnitRootPath \"" + serviceUnitRootPath + "\"");
	return null;
    }

    public void init(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
	System.err.println(NAME + ".init(String serviceUnitName, String serviceUnitRootPath) called");
	System.err.println("\tserviceUnitName \"" + serviceUnitName + "\"");
	System.err.println("\tserviceUnitRootPath \"" + serviceUnitRootPath + "\"");
    }

    public void start(String serviceUnitName) throws DeploymentException {
	System.err.println(NAME + ".start(String serviceUnitName) called"); 
	System.err.println("\tserviceUnitName \"" + serviceUnitName + "\"");
    }

    public void shutDown(String serviceUnitName) throws DeploymentException {
	System.err.println(NAME + ".shutdown(String serviceUnitName) called");
	System.err.println("\tserviceUnitName \"" + serviceUnitName + "\"");
    }

    public void stop(String serviceUnitName) throws DeploymentException {
	System.err.println(NAME + ".stop(String serviceUnitName) called");
	System.err.println("\tserviceUnitName \"" + serviceUnitName + "\"");
    }

    public String undeploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
	System.err.println(NAME + ".undeploy(String serviceUnitName, String serviceUnitRootPath) called");
	System.err.println("\tserviceUnitName \"" + serviceUnitName + "\"");
	System.err.println("\tserviceUnitRootPath \"" + serviceUnitRootPath + "\"");
	return null;
    }

} // end class BaseComponent
