/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.api.ManagedTaskListener;

import java.util.concurrent.TimeUnit;

import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ListenerEvent;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ManagedTaskListenerImpl;

public class RunnableTaskWithStatus implements Runnable{
    private final ManagedTaskListenerImpl listener;
    private final int blockTime;
    public RunnableTaskWithStatus(ManagedTaskListenerImpl listener) {
        this.listener = listener;
        blockTime = 0;
    }
    RunnableTaskWithStatus(ManagedTaskListenerImpl listener, int blockTime) {
        this.listener = listener;
        this.blockTime = blockTime;
    }
    public void run() {
        listener.update(ListenerEvent.TASK_RUN);
        if(blockTime > 0) {
            try {
                TimeUnit.SECONDS.sleep(blockTime);
            } catch (InterruptedException e) {
            }
        }
    }

}
