/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Release {
    public static final Release BOOT_CLASS_PATH = new Release('0', null);
    private final char version;
    private final String[] prefixes;
    private static final Map<Character, Release> RELEASES;

    private Release(char version, String ... prefixes) {
        this.version = version;
        this.prefixes = prefixes;
    }

    public static Release find(int version) {
        if (version > 15) {
            return null;
        }
        char ch = (char)(version < 10 ? 48 + version : 65 + (version - 10));
        return RELEASES.get(Character.valueOf(ch));
    }

    InputStream findClass(String name) {
        if (this.prefixes == null) {
            String resourceName = name.replace('.', '/') + ".class";
            return ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        }
        for (String p : this.prefixes) {
            String resourceName = "/META-INF/sigtest/" + p + "/" + name.replace('.', '/') + ".sig";
            InputStream is = Release.class.getResourceAsStream(resourceName);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    static {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(Release.class.getResourceAsStream("/META-INF/sigtest.ls")));){
            Object l;
            while ((l = r.readLine()) != null) {
                lines.add((String)l);
            }
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        HashMap<Character, ArrayList<String>> prefixes = new HashMap<Character, ArrayList<String>>();
        for (String l : lines) {
            String[] versionsDir = l.split("/");
            String versions = versionsDir[0];
            for (int i = 0; i < versions.length(); ++i) {
                Character ch = Character.valueOf(versions.charAt(i));
                ArrayList<String> arr = (ArrayList<String>)prefixes.get(ch);
                if (arr == null) {
                    arr = new ArrayList<String>();
                    prefixes.put(ch, arr);
                }
                arr.add(l);
            }
        }
        HashMap<Character, Release> releases = new HashMap<Character, Release>();
        for (Map.Entry entry : prefixes.entrySet()) {
            Character key = (Character)entry.getKey();
            List value = (List)entry.getValue();
            releases.put(key, new Release(key.charValue(), value.toArray(new String[0])));
        }
        RELEASES = releases;
    }
}

