/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.tests.jaspic.tssv.util.TSFileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TSLogger
extends Logger {
    private static TSLogger tsLogger = null;
    private int levelValue = Level.INFO.intValue();
    private int offValue = Level.OFF.intValue();
    private String name = null;
    private Filter filter;

    protected TSLogger(String name) {
        super(name, null);
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    public static synchronized TSLogger getTSLogger(String name) {
        TSLogger result = null;
        LogManager manager = LogManager.getLogManager();
        if (tsLogger != null) {
            if (tsLogger.getName().equals(name)) {
                result = tsLogger;
            }
        } else {
            result = new TSLogger(name);
            manager.addLogger(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void log(LogRecord record) {
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == this.offValue) {
            return;
        }
        TSLogger tSLogger = this;
        synchronized (tSLogger) {
            if (this.filter != null && !this.filter.isLoggable(record)) {
                return;
            }
        }
        TSLogger logger = this;
        while (logger != null) {
            Handler[] targets = logger.getHandlers();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    if (!(targets[i] instanceof TSFileHandler)) continue;
                    targets[i].publish(record);
                }
            }
            if (!logger.getUseParentHandlers()) break;
            logger = null;
        }
    }
}

