/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlMultiColumn;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;

@JsxClasses(value={@JsxClass(domClass=HtmlMultiColumn.class, browsers={@WebBrowser(value=BrowserName.FF, maxVersion=17.0f), @WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlSpan.class)})
public class HTMLSpanElement
extends HTMLElement {
    private boolean endTagForbidden_;

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        BrowserVersion browser = this.getBrowserVersion();
        if (browser.hasFeature(BrowserVersionFeatures.HTMLBASEFONT_END_TAG_FORBIDDEN) && "basefont".equalsIgnoreCase(domNode.getLocalName())) {
            this.endTagForbidden_ = true;
        }
    }

    public String getCite() {
        String cite = this.getDomNodeOrDie().getAttribute("cite");
        return cite;
    }

    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    public String getDateTime() {
        String dateTime = this.getDomNodeOrDie().getAttribute("datetime");
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.getDomNodeOrDie().setAttribute("datetime", dateTime);
    }

    @Override
    protected boolean isLowerCaseInOuterHtml() {
        if (this.getDomNodeOrDie() instanceof HtmlMultiColumn) {
            return true;
        }
        return super.isLowerCaseInOuterHtml();
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }
}

