/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.Utils;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LoggerInfo;

public class GrizzlyConfig {
    @LoggerInfo(subsystem="NETCONFIG", description="Network config", publish=false)
    private static final String LOGGER_NAME = "javax.enterprise.network.config";
    private static final Logger LOGGER = Logger.getLogger("javax.enterprise.network.config");
    private final NetworkConfig config;
    private final ServiceLocator serviceLocator;
    private final List<GrizzlyListener> listeners = new ArrayList<GrizzlyListener>();

    public static Logger logger() {
        return LOGGER;
    }

    public GrizzlyConfig(String file) {
        this.serviceLocator = Utils.getServiceLocator(file);
        this.config = (NetworkConfig)this.serviceLocator.getService(NetworkConfig.class, new Annotation[0]);
    }

    public NetworkConfig getConfig() {
        return this.config;
    }

    public List<GrizzlyListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupNetwork() throws IOException {
        GrizzlyConfig.validateConfig(this.config);
        List<GrizzlyListener> list = this.listeners;
        synchronized (list) {
            for (NetworkListener listener : this.config.getNetworkListeners().getNetworkListener()) {
                GenericGrizzlyListener grizzlyListener = new GenericGrizzlyListener();
                grizzlyListener.configure(this.serviceLocator, listener);
                this.listeners.add(grizzlyListener);
                try {
                    grizzlyListener.start();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNetwork() {
        List<GrizzlyListener> list = this.listeners;
        synchronized (list) {
            for (GrizzlyListener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.listeners.clear();
        }
    }

    private static void validateConfig(NetworkConfig config) {
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            listener.findHttpProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        List<GrizzlyListener> list = this.listeners;
        synchronized (list) {
            for (GrizzlyListener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.listeners.clear();
        }
    }

    public static boolean toBoolean(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        String v = value.trim();
        return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
    }
}

