/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.InvalidJvmOptionException;
import com.sun.enterprise.admin.util.JvmOptionsElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class JvmOptionsHelper {
    private final JvmOptionsElement head;

    public JvmOptionsHelper(String[] options) throws InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        this.head = options.length == 0 ? new JvmOptionsElement("") : new JvmOptionsElement(options[0]);
        JvmOptionsElement current = this.head;
        for (int i = 1; i < options.length; ++i) {
            JvmOptionsElement next = new JvmOptionsElement(options[i]);
            current.setNext(next);
            current = next;
        }
    }

    public String[] addJvmOptions(String[] options) throws InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        HashSet<String> alreadyExist = new HashSet<String>();
        JvmOptionsElement last = this.last();
        for (int i = 0; i < options.length; ++i) {
            if (!this.head.hasOption(options[i])) {
                JvmOptionsElement x = new JvmOptionsElement(options[i]);
                last.setNext(x);
                last = x;
                continue;
            }
            alreadyExist.add(options[i]);
        }
        return JvmOptionsHelper.toStringArray(alreadyExist);
    }

    public JvmOptionsElement last() {
        JvmOptionsElement current = this.head;
        while (current.hasNext()) {
            current = current.next();
        }
        return current;
    }

    public String[] deleteJvmOptions(String[] options) {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        HashSet<String> donotExist = new HashSet<String>();
        for (int i = 0; i < options.length; ++i) {
            if (this.head.deleteJvmOption(options[i])) continue;
            donotExist.add(options[i]);
        }
        return JvmOptionsHelper.toStringArray(donotExist);
    }

    public String[] getJvmOptionsAsStoredInXml() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        JvmOptionsElement current = this.head;
        while (!JvmOptionsElement.isLast(current)) {
            String options = current.getJvmOptionsAsStoredInXml();
            if (options != null && options.length() > 0) {
                s.add(options);
            }
            current = current.next();
        }
        return JvmOptionsHelper.toStringArray(s);
    }

    public String[] getJvmOptions() {
        LinkedHashSet s = new LinkedHashSet();
        JvmOptionsElement current = this.head;
        while (!JvmOptionsElement.isLast(current)) {
            ArrayList options = current.getJvmOptions();
            if (options != null && options.size() > 0) {
                s.addAll(options);
            }
            current = current.next();
        }
        return JvmOptionsHelper.toStringArray(s);
    }

    public static String[] toStringArray(Collection c) {
        String[] s = new String[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            s[i] = (String)it.next();
            ++i;
        }
        return s;
    }
}

