/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.gms.tools.MulticastTester;
import com.sun.enterprise.gms.tools.StringManager;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.logging.Level;

public class MulticastSenderThread
extends Thread {
    static final StringManager sm = StringManager.getInstance();
    volatile boolean done = false;
    int mcPort;
    String mcAddress;
    String bindInterface;
    int ttl;
    long msgPeriodInMillis;
    boolean debug;
    String dataString;

    public MulticastSenderThread(int mcPort, String mcAddress, String bindInterface, int ttl, long msgPeriodInMillis, boolean debug, String dataString) {
        super("McastSender");
        this.mcPort = mcPort;
        this.mcAddress = mcAddress;
        this.bindInterface = bindInterface;
        this.ttl = ttl;
        this.msgPeriodInMillis = msgPeriodInMillis;
        this.debug = debug;
        this.dataString = dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block31: {
            DatagramSocket socket;
            InetAddress group;
            block32: {
                InetAddress iaddr;
                group = null;
                socket = null;
                byte[] data = this.dataString.getBytes(Charset.defaultCharset());
                group = InetAddress.getByName(this.mcAddress);
                DatagramPacket datagramPacket = new DatagramPacket(data, data.length, group, this.mcPort);
                socket = new MulticastSocket(this.mcPort);
                if (this.bindInterface != null) {
                    iaddr = InetAddress.getByName(this.bindInterface);
                    this.log("InetAddress.getByName returned: " + iaddr);
                    NetworkInterface ni = NetworkInterface.getByInetAddress(iaddr);
                    if (ni != null && NetworkUtility.isUp(ni)) {
                        ((MulticastSocket)socket).setInterface(iaddr);
                        System.out.println(String.format(sm.get("configured.bindinterface", this.bindInterface, ni.getName(), ni.getDisplayName(), NetworkUtility.isUp(ni), ni.isLoopback()), new Object[0]));
                    } else {
                        if (ni != null) {
                            System.out.println(String.format(sm.get("invalid.bindinterface", this.bindInterface, ni.getName(), ni.getDisplayName(), NetworkUtility.isUp(ni), ni.isLoopback()), new Object[0]));
                        } else {
                            System.err.println(sm.get("nonexistent.bindinterface", this.bindInterface));
                        }
                        iaddr = this.getFirstAddress();
                        this.log("setting socket to: " + iaddr + " instead");
                        ((MulticastSocket)socket).setInterface(iaddr);
                    }
                } else {
                    iaddr = this.getFirstAddress();
                    this.log("setting socket to: " + iaddr);
                    ((MulticastSocket)socket).setInterface(iaddr);
                }
                if (this.ttl != -1) {
                    try {
                        ((MulticastSocket)socket).setTimeToLive(this.ttl);
                    }
                    catch (Exception e) {
                        System.err.println(sm.get("could.not.set.ttl", e.getLocalizedMessage()));
                    }
                } else {
                    try {
                        int defaultTTL = ((MulticastSocket)socket).getTimeToLive();
                        if (defaultTTL < 4) {
                            this.log(String.format("The default TTL for the socket is %d. Setting it to minimum %d instead.", defaultTTL, 4));
                            ((MulticastSocket)socket).setTimeToLive(4);
                        }
                    }
                    catch (IOException defaultTTL) {
                        // empty catch block
                    }
                }
                this.log("setting loopback mode false on mcast socket");
                ((MulticastSocket)socket).setLoopbackMode(false);
                try {
                    this.log(String.format("socket time to live set to %s", ((MulticastSocket)socket).getTimeToLive()));
                }
                catch (IOException ioe) {
                    this.log(ioe.getLocalizedMessage());
                }
                this.log(String.format("joining group: %s", group.toString()));
                ((MulticastSocket)socket).joinGroup(group);
                if (!this.debug) {
                    this.dataString = MulticastTester.trimDataString(this.dataString);
                }
                System.out.println(sm.get("sending.message", this.dataString, this.msgPeriodInMillis));
                while (!this.done) {
                    socket.send(datagramPacket);
                    try {
                        Thread.sleep(this.msgPeriodInMillis);
                    }
                    catch (InterruptedException ie) {
                        this.log("interrupted");
                        break;
                    }
                }
                if (socket == null) break block31;
                if (group == null) break block32;
                this.log("socket leaving group");
                try {
                    ((MulticastSocket)socket).leaveGroup(group);
                }
                catch (IOException ioe) {
                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                }
            }
            this.log("closing socket");
            socket.close();
            break block31;
            catch (Exception e) {
                block33: {
                    try {
                        System.err.println(sm.get("whoops", e.toString()));
                        if (socket == null) break block31;
                        if (group == null) break block33;
                        this.log("socket leaving group");
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            if (group != null) {
                                this.log("socket leaving group");
                                try {
                                    ((MulticastSocket)socket).leaveGroup(group);
                                }
                                catch (IOException ioe) {
                                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                                }
                            }
                            this.log("closing socket");
                            socket.close();
                        }
                        throw throwable;
                    }
                    try {
                        ((MulticastSocket)socket).leaveGroup(group);
                    }
                    catch (IOException ioe) {
                        System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                    }
                }
                this.log("closing socket");
                socket.close();
            }
        }
    }

    private InetAddress getFirstAddress() throws IOException {
        if (!this.debug) {
            GMSLogDomain.getLogger("ShoalLogger").setLevel(Level.SEVERE);
        }
        return NetworkUtility.getFirstInetAddress(false);
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println(String.format("%s: %s", this.getName(), msg));
        }
    }
}

