/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.iiop;

import com.sun.corba.ee.impl.txpoa.TSIdentificationImpl;
import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.enterprise.transaction.jts.iiop.TxIORInterceptor;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DefaultTransactionService;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.pfl.basic.func.NullaryFunction;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TSIdentification;
import org.omg.CosTransactions.Current;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="TransactionIIOPInterceptorFactory")
public class TransactionIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static Logger _logger = LogDomains.getLogger(InterceptorImpl.class, (String)"javax.enterprise.system.core.transaction");
    private static Properties jtsProperties = new Properties();
    private static TSIdentificationImpl tsIdent = new TSIdentificationImpl();
    private static boolean txServiceInitialized = false;
    private InterceptorImpl interceptor = null;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ProcessEnvironment processEnv;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!txServiceInitialized) {
            this.createInterceptor(info, codec);
        }
        return this.interceptor;
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!txServiceInitialized) {
            this.createInterceptor(info, codec);
        }
        return this.interceptor;
    }

    private void createInterceptor(ORBInitInfo info, Codec codec) {
        if (this.processEnv.getProcessType().isServer()) {
            try {
                System.setProperty("com.sun.jts.pi.CLIENT_POLICY_CHECKING", String.valueOf(false));
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "iiop.readproperty_exception", ex);
            }
            this.initJTSProperties(true);
        } else {
            this.initJTSProperties(false);
        }
        try {
            org.omg.PortableInterceptor.Current pic = (org.omg.PortableInterceptor.Current)info.resolve_initial_references("PICurrent");
            int[] slotIds = new int[]{info.allocate_slot_id(), info.allocate_slot_id()};
            this.interceptor = new InterceptorImpl(pic, codec, slotIds, null);
            com.sun.corba.ee.spi.orb.ORB theORB = ((ORBInitInfoExt)info).getORB();
            InterceptorImpl.setOrb((ORB)theORB);
            try {
                DefaultTransactionService jts = new DefaultTransactionService();
                jts.identify_ORB((ORB)theORB, (TSIdentification)tsIdent, jtsProperties);
                this.interceptor.setTSIdentification((TSIdentification)tsIdent);
                Current transactionCurrent = jts.get_current();
                theORB.getLocalResolver().register("TransactionCurrent", NullaryFunction.Factory.makeConstant((Object)transactionCurrent));
                theORB.getLocalResolver().register("TSIdentification", NullaryFunction.Factory.makeConstant((Object)tsIdent));
                txServiceInitialized = true;
            }
            catch (Exception ex) {
                throw new INITIALIZE("JTS Exception: " + ex, POASystemException.JTS_INIT_ERROR, CompletionStatus.COMPLETED_MAYBE);
            }
            TxIORInterceptor iorInterceptor = new TxIORInterceptor(codec, this.serviceLocator);
            info.add_ior_interceptor((IORInterceptor)iorInterceptor);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private void initJTSProperties(boolean isServer) {
        if (this.serviceLocator != null) {
            jtsProperties = TransactionServiceProperties.getJTSProperties(this.serviceLocator, true);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "++++ Server id: " + jtsProperties.getProperty("org.omg.CORBA.ORBServerId"));
            }
            if (isServer) {
                Configuration.setProperties(jtsProperties);
            }
        }
    }
}

