/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.callback;

import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.jmac.callback.BaseContainerCallbackHandler;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;

final class ClientContainerCallbackHandler
extends BaseContainerCallbackHandler {
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";

    ClientContainerCallbackHandler() {
    }

    @Override
    protected void handleSupportedCallbacks(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        boolean processedSomeAppclientCallbacks = false;
        for (int i = 0; i < callbacks.length; ++i) {
            if (!processedSomeAppclientCallbacks && (callbacks[i] instanceof NameCallback || callbacks[i] instanceof PasswordCallback || callbacks[i] instanceof ChoiceCallback)) {
                String loginName = UsernamePasswordStore.getUsername();
                char[] password = UsernamePasswordStore.getPassword();
                boolean doSet = false;
                if (loginName == null) {
                    loginName = System.getProperty(LOGIN_NAME);
                    doSet = true;
                }
                if (password == null) {
                    password = System.getProperty(LOGIN_PASSWORD).toCharArray();
                    doSet = true;
                }
                if (doSet) {
                    UsernamePasswordStore.set((String)loginName, (char[])password);
                }
                CallbackHandler callbackHandler = SecurityServicesUtil.getInstance().getCallbackHandler();
                if (loginName != null && password != null) {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callback;
                            nc.setName(loginName);
                            continue;
                        }
                        if (!(callback instanceof PasswordCallback)) continue;
                        PasswordCallback pc = (PasswordCallback)callback;
                        pc.setPassword(password);
                    }
                } else {
                    callbackHandler.handle(callbacks);
                }
                processedSomeAppclientCallbacks = true;
                break;
            }
            this.processCallback(callbacks[i]);
        }
    }

    @Override
    protected boolean isSupportedCallback(Callback callback) {
        boolean supported = false;
        if (callback instanceof NameCallback || callback instanceof PasswordCallback || callback instanceof ChoiceCallback || callback instanceof CallerPrincipalCallback || callback instanceof GroupPrincipalCallback || callback instanceof CertStoreCallback || callback instanceof PasswordValidationCallback || callback instanceof SecretKeyCallback || callback instanceof PrivateKeyCallback || callback instanceof TrustStoreCallback) {
            supported = true;
        }
        return supported;
    }
}

