/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.extras.osgicontainer.OSGiArchiveType;
import org.glassfish.extras.osgicontainer.OSGiSniffer;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="osgi")
@Singleton
public class OSGiArchiveDetector
implements ArchiveDetector {
    public static final String OSGI_ARCHIVE_DETECTOR_RANK_PROP = "glassfish.ear.detector.rank";
    public static final int DEFAULT_OSGI_ARCHIVE_DETECTOR_RANK = Integer.MAX_VALUE;
    public static final String OSGI_ARCHIVE_TYPE = "osgi";
    @Inject
    private ServiceLocator services;
    @Inject
    private OSGiSniffer sniffer;
    @Inject
    private OSGiArchiveType archiveType;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public int rank() {
        return Integer.getInteger(OSGI_ARCHIVE_DETECTOR_RANK_PROP, Integer.MAX_VALUE);
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        OSGiArchiveDetector oSGiArchiveDetector = this;
        synchronized (oSGiArchiveDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = (ArchiveHandler)this.services.getService(ArchiveHandler.class, OSGI_ARCHIVE_TYPE, new Annotation[0]);
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }
}

