/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.EjbConversionHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.NameMapper;
import com.sun.jdo.spi.persistence.support.ejb.model.DeploymentDescriptorModel;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationRoleDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;
import org.netbeans.modules.dbschema.SchemaElement;

public class EJBBundleInfoHelper
implements EJBInfoHelper {
    private static final char UNDERLINE = '_';
    private static final char DOT = '.';
    private final EjbBundleDescriptorImpl bundleDescriptor;
    private Collection availableSchemaNames;
    private NameMapper nameMapper;
    private Model model;

    public EJBBundleInfoHelper(EjbBundleDescriptorImpl bundleDescriptor, Collection availableSchemaNames) {
        this(bundleDescriptor, null, null, availableSchemaNames);
    }

    EJBBundleInfoHelper(EjbBundleDescriptorImpl bundleDescriptor, NameMapper nameMapper, Model model, Collection availableSchemaNames) {
        this.bundleDescriptor = bundleDescriptor;
        this.nameMapper = nameMapper;
        this.model = model;
        this.availableSchemaNames = availableSchemaNames;
    }

    private EjbBundleDescriptorImpl getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public String getEjbJarDisplayName() {
        return this.bundleDescriptor.getName();
    }

    public Collection getAvailableSchemaNames() {
        return this.availableSchemaNames;
    }

    public String getSchemaNameToGenerate() {
        return DeploymentHelper.getDDLNamePrefix((Object)this.getBundleDescriptor()).replace('.', '_');
    }

    public SchemaElement getSchema(String schemaName) {
        return SchemaElement.forName((String)schemaName, (Object)this.getClassLoader());
    }

    public Collection getEjbNames() {
        Iterator iterator = this.getBundleDescriptor().getEjbs().iterator();
        ArrayList<String> returnList = new ArrayList<String>();
        while (iterator.hasNext()) {
            EjbDescriptor ejb = (EjbDescriptor)iterator.next();
            if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
            returnList.add(ejb.getName());
        }
        return returnList;
    }

    public Collection getFieldsForEjb(String ejbName) {
        Iterator iterator = this.getModel().getFields(ejbName).iterator();
        ArrayList returnList = new ArrayList();
        while (iterator.hasNext()) {
            returnList.add(iterator.next());
        }
        return returnList;
    }

    public Collection getRelationshipsForEjb(String ejbName) {
        Iterator iterator = this.getBundleDescriptor().getRelationships().iterator();
        ArrayList<String> returnList = new ArrayList<String>();
        while (iterator.hasNext()) {
            RelationshipDescriptor relD = (RelationshipDescriptor)iterator.next();
            RelationRoleDescriptor testRole = relD.getSource();
            String cmrField = null;
            if (ejbName.equals(testRole.getOwner().getName()) && (cmrField = testRole.getCMRField()) != null) {
                returnList.add(cmrField);
            }
            if (!ejbName.equals((testRole = relD.getSink()).getOwner().getName()) || (cmrField = testRole.getCMRField()) == null) continue;
            returnList.add(cmrField);
        }
        return returnList;
    }

    public ClassLoader getClassLoader() {
        return this.bundleDescriptor.getClassLoader();
    }

    public AbstractNameMapper getNameMapper() {
        return this.getNameMapperInternal();
    }

    public AbstractNameMapper createUniqueNameMapper() {
        return new NameMapper(this.bundleDescriptor);
    }

    private NameMapper getNameMapperInternal() {
        if (this.nameMapper == null) {
            this.nameMapper = new NameMapper(this.bundleDescriptor, false);
        }
        return this.nameMapper;
    }

    public ConversionHelper createConversionHelper() {
        return new EjbConversionHelper(this.getNameMapperInternal());
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = new DeploymentDescriptorModel(this.getNameMapperInternal(), this.getClassLoader());
        }
        return this.model;
    }
}

