/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.sse.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.glassfish.sse.api.ServerSentEvent;
import org.glassfish.sse.api.ServerSentEventHandler;
import org.glassfish.sse.impl.ServerSentEventServlet;

@HandlesTypes(value={ServerSentEvent.class})
public class ServerSentEventServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> set, ServletContext ctx) throws ServletException {
        if (set == null || set.isEmpty()) {
            return;
        }
        Map registrations = ctx.getServletRegistrations();
        for (Object reg : registrations.values()) {
            if (!reg.getClass().equals(ServerSentEventServlet.class)) continue;
            return;
        }
        ArrayList<String> urlPatternList = new ArrayList<String>();
        for (Class clazz : set) {
            if (!ServerSentEventHandler.class.isAssignableFrom(clazz)) continue;
            ServerSentEvent handler = clazz.getAnnotation(ServerSentEvent.class);
            if (handler == null) {
                throw new RuntimeException("ServerSentEventHandler Class " + clazz + " doesn't have WebHandler annotation");
            }
            urlPatternList.add(handler.value());
        }
        if (!urlPatternList.isEmpty()) {
            Object reg;
            reg = ctx.addServlet("sse servlet", ServerSentEventServlet.class);
            reg.setAsyncSupported(true);
            reg.addMapping(urlPatternList.toArray(new String[urlPatternList.size()]));
        }
    }
}

