/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class FacesConfigParser {
    private final DocumentBuilder documentBuilder = this.createDocumentBuilder();
    private Consumer<Element> onStartElement = e -> System.out.println("START: " + e.getNodeName());
    private BiConsumer<Element, Text> onLeafElementWithText = (e, t) -> System.out.println("Value: " + t.getWholeText().trim());
    private Consumer<Element> onEndElement = e -> System.out.println("END: " + e.getNodeName());
    private boolean skipDocumentRoot = true;

    public void parseFromRelativePath(String rootPath) throws IOException {
        System.out.println("Scanning from " + rootPath + " = " + Paths.get(rootPath, new String[0]).toAbsolutePath().toRealPath(new LinkOption[0]) + "\n");
        this.parse(this.document(Paths.get(rootPath, new String[0])).getDocumentElement());
    }

    public void parseFromClassPath(String resource) throws IOException {
        try {
            URL documentURL = new URI(this.getClass().getClassLoader().getResource(resource).toExternalForm().replaceAll(" ", "%20")).toURL();
            InputSource is = new InputSource(FacesConfigParser.getInputStream(documentURL));
            is.setSystemId(documentURL.toExternalForm());
            this.parse(this.document(is).getDocumentElement());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void parse(Element root) throws IOException {
        ArrayDeque<Element> elements = new ArrayDeque<Element>();
        if (this.skipDocumentRoot) {
            this.pushChildElements(elements, this.getChildElements(root.getChildNodes()));
        } else {
            elements.push(root);
        }
        Element currentElement = null;
        Node previousElement = null;
        while (!elements.isEmpty()) {
            currentElement = (Element)elements.peek();
            if (previousElement != null && (previousElement.getParentNode().isEqualNode(currentElement) || previousElement.isEqualNode(currentElement))) {
                elements.pop();
                this.onEndElement.accept(currentElement);
            } else {
                this.onStartElement.accept(currentElement);
                List<Element> childElements = this.getChildElements(currentElement.getChildNodes());
                if (childElements.isEmpty()) {
                    Element parentElement = currentElement;
                    this.getTextContent(parentElement.getChildNodes()).stream().findAny().ifPresent(e -> this.onLeafElementWithText.accept(parentElement, (Text)e));
                } else {
                    this.pushChildElements(elements, childElements);
                }
            }
            previousElement = currentElement;
        }
    }

    public void setOnStartElement(Consumer<Element> onStartElement) {
        this.onStartElement = onStartElement;
    }

    public void setOnLeafElementWithText(BiConsumer<Element, Text> onLeafElementWithText) {
        this.onLeafElementWithText = onLeafElementWithText;
    }

    public void setOnEndElement(Consumer<Element> onEndElement) {
        this.onEndElement = onEndElement;
    }

    public boolean isSkipDocumentRoot() {
        return this.skipDocumentRoot;
    }

    public void setSkipDocumentRoot(boolean skipDocumentRoot) {
        this.skipDocumentRoot = skipDocumentRoot;
    }

    private void pushChildElements(Deque<Element> elements, List<Element> childElements) {
        for (Element child : this.reverse(childElements)) {
            elements.push(child);
        }
    }

    private DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private Document document(Path path) {
        try {
            return this.document(new InputSource(Files.newInputStream(path, new OpenOption[0])));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Document document(InputSource inputSource) {
        try {
            Document document = this.documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Element> getChildElements(NodeList nodes) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        int i = 0;
        while (true) {
            block18: {
                Node node;
                block19: {
                    if (i >= nodes.getLength()) {
                        return childElements;
                    }
                    node = nodes.item(i);
                    if (node.getNodeType() != 1) break block18;
                    if (node.getParentNode() == null || node.getParentNode().getNodeName() == null) break block19;
                    String nodeName = node.getNodeName();
                    String grandParentName = node.getParentNode().getParentNode() == null ? null : node.getParentNode().getParentNode().getNodeName();
                    switch (node.getParentNode().getNodeName()) {
                        case "component": {
                            if ("component-type".equals(nodeName) || "component-class".equals(nodeName)) break;
                            break block18;
                        }
                        case "converter": {
                            if ("converter-id".equals(nodeName) || "converter-class".equals(nodeName) || "converter-for-class".equals(nodeName)) break;
                            break block18;
                        }
                        case "validator": {
                            if ("validator-id".equals(nodeName) || "validator-class".equals(nodeName)) break;
                            break block18;
                        }
                        case "render-kit": {
                            if ("render-kit-id".equals(nodeName) || "render-kit-class".equals(nodeName) || "renderer".equals(nodeName) || "client-behavior-renderer".equals(nodeName)) break;
                            break block18;
                        }
                        case "renderer": {
                            if (!"render-kit".equals(grandParentName) || "component-family".equals(nodeName) || "renderer-type".equals(nodeName) || "renderer-class".equals(nodeName)) break;
                            break block18;
                        }
                        case "client-behavior-renderer": {
                            if ("render-kit".equals(grandParentName) && !"client-behavior-renderer-type".equals(nodeName) && !"client-behavior-renderer-class".equals(nodeName)) break block18;
                        }
                    }
                }
                childElements.add((Element)node);
            }
            ++i;
        }
    }

    private List<Text> getTextContent(NodeList nodes) {
        ArrayList<Text> childElements = new ArrayList<Text>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            childElements.add((Text)node);
        }
        return childElements;
    }

    private List<Element> reverse(List<Element> list) {
        Collections.reverse(list);
        return list;
    }

    private static InputStream getInputStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }
}

