/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.utils;

import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;

public class ChunkedCompletionHandler
implements CompletionHandler<WriteResult> {
    private final CompletionHandler<WriteResult> parentCompletionHandler;
    private boolean isDone;
    protected int chunksCounter = 1;
    private long writtenSize;

    public ChunkedCompletionHandler(CompletionHandler<WriteResult> parentCompletionHandler) {
        this.parentCompletionHandler = parentCompletionHandler;
    }

    public void incChunks() {
        ++this.chunksCounter;
    }

    @Override
    public void cancelled() {
        if (this.done() && this.parentCompletionHandler != null) {
            this.parentCompletionHandler.cancelled();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this.done() && this.parentCompletionHandler != null) {
            this.parentCompletionHandler.failed(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(WriteResult result) {
        if (this.isDone) {
            return;
        }
        if (--this.chunksCounter == 0) {
            this.done();
            long initialWrittenSize = result.getWrittenSize();
            this.writtenSize += initialWrittenSize;
            if (this.parentCompletionHandler != null) {
                try {
                    result.setWrittenSize(this.writtenSize);
                    this.parentCompletionHandler.completed(result);
                }
                finally {
                    result.setWrittenSize(initialWrittenSize);
                }
            }
        } else {
            this.updated(result);
            this.writtenSize += result.getWrittenSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updated(WriteResult result) {
        if (this.parentCompletionHandler != null) {
            long initialWrittenSize = result.getWrittenSize();
            try {
                result.setWrittenSize(this.writtenSize + initialWrittenSize);
                this.parentCompletionHandler.updated(result);
            }
            finally {
                result.setWrittenSize(initialWrittenSize);
            }
        }
    }

    private boolean done() {
        if (this.isDone) {
            return false;
        }
        this.isDone = true;
        this.done0();
        return true;
    }

    protected void done0() {
    }
}

