/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.NamedNodeMapIterator;
import com.sun.xml.rpc.util.xml.NullEntityResolver;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import com.sun.xml.rpc.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaParser {
    private boolean _followImports;
    private static final String PREFIX_XMLNS = "xmlns";
    private static final String PREFIX_XMLNS_COLON = "xmlns:";

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean b) {
        this._followImports = b;
    }

    public SchemaDocument parse(InputSource source) {
        SchemaDocument schemaDocument = new SchemaDocument();
        schemaDocument.setSystemId(source.getSystemId());
        ParserContext context = new ParserContext(schemaDocument, null);
        context.setFollowImports(this._followImports);
        schemaDocument.setSchema(this.parseSchema(context, source, null));
        return schemaDocument;
    }

    public Schema parseSchema(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
        Schema schema = this.parseSchemaNoImport(context, source, expectedTargetNamespaceURI);
        schema.defineAllEntities();
        this.processImports(context, source, schema);
        return schema;
    }

    public Schema parseSchema(ParserContext context, Element e, String expectedTargetNamespaceURI) {
        Schema schema = this.parseSchemaNoImport(context, e, expectedTargetNamespaceURI);
        schema.defineAllEntities();
        this.processImports(context, null, schema);
        return schema;
    }

    protected void processImports(ParserContext context, InputSource source, Schema schema) {
        Iterator iter = schema.getContent().children();
        while (iter.hasNext()) {
            String location;
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_IMPORT)) {
                location = child.getValueOfAttributeOrNull("schemaLocation");
                String namespace = child.getValueOfAttributeOrNull("namespace");
                if (location == null) continue;
                String adjustedLocation = null;
                if (source != null && source.getSystemId() != null) {
                    adjustedLocation = Util.processSystemIdWithBase(source.getSystemId(), location);
                }
                if (adjustedLocation == null) {
                    String string2 = adjustedLocation = context.getWSDLLocation() == null ? location : Util.processSystemIdWithBase(context.getWSDLLocation(), location);
                }
                if (context.getDocument().isImportedDocument(adjustedLocation)) continue;
                context.getDocument().addImportedDocument(adjustedLocation);
                context.getDocument().addImportedEntity(this.parseSchema(context, new InputSource(adjustedLocation), namespace));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_INCLUDE) && schema.getTargetNamespaceURI() != null) {
                location = child.getValueOfAttributeOrNull("schemaLocation");
                if (location == null || context.getDocument().isIncludedDocument(location)) continue;
                context.getDocument().addIncludedDocument(location);
                String adjustedLocation = null;
                if (source != null && source.getSystemId() != null) {
                    adjustedLocation = Util.processSystemIdWithBase(source.getSystemId(), location);
                }
                if (adjustedLocation == null) {
                    adjustedLocation = context.getDocument().getSystemId() == null ? location : Util.processSystemIdWithBase(context.getDocument().getSystemId(), location);
                }
                context.getDocument().addIncludedEntity(this.parseSchema(context, new InputSource(adjustedLocation), schema.getTargetNamespaceURI()));
                continue;
            }
            if (!child.getQName().equals(SchemaConstants.QNAME_REDEFINE)) continue;
            Util.fail("validation.unsupportedSchemaFeature", "redefine");
        }
    }

    protected Schema parseSchemaNoImport(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public void warning(SAXParseException err) throws SAXParseException {
                }
            });
            builder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = builder.parse(source);
                return this.parseSchemaNoImport(context, document, expectedTargetNamespaceURI);
            }
            catch (IOException e) {
                throw new ParseException("parsing.ioException", new LocalizableExceptionAdapter(e));
            }
            catch (SAXException e) {
                throw new ParseException("parsing.saxException", new LocalizableExceptionAdapter(e));
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("parsing.parserConfigException", new LocalizableExceptionAdapter(e));
        }
        catch (FactoryConfigurationError e) {
            throw new ParseException("parsing.factoryConfigException", new LocalizableExceptionAdapter(e));
        }
    }

    protected Schema parseSchemaNoImport(ParserContext context, Document doc, String expectedTargetNamespaceURI) {
        Element root = doc.getDocumentElement();
        Util.verifyTagNSRootElement(root, SchemaConstants.QNAME_SCHEMA);
        return this.parseSchemaNoImport(context, root, expectedTargetNamespaceURI);
    }

    protected Schema parseSchemaNoImport(ParserContext context, Element e, String expectedTargetNamespaceURI) {
        Schema schema = new Schema(context.getDocument());
        String targetNamespaceURI = XmlUtil.getAttributeOrNull(e, "targetNamespace");
        if (targetNamespaceURI != null && expectedTargetNamespaceURI != null && !expectedTargetNamespaceURI.equals(targetNamespaceURI)) {
            throw new ValidationException("validation.incorrectTargetNamespace", new Object[]{targetNamespaceURI, expectedTargetNamespaceURI});
        }
        if (targetNamespaceURI == null) {
            schema.setTargetNamespaceURI(expectedTargetNamespaceURI);
        } else {
            schema.setTargetNamespaceURI(targetNamespaceURI);
        }
        Iterator iter = context.getPrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String nsURI = context.getNamespaceURI(prefix);
            if (nsURI == null) {
                throw new ParseException("parsing.shouldNotHappen");
            }
            schema.addPrefix(prefix, nsURI);
        }
        context.push();
        context.registerNamespaces(e);
        SchemaElement schemaElement = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
        this.copyNamespaceDeclarations(schemaElement, e);
        this.copyAttributesNoNs(schemaElement, e);
        this.copyElementContent(schemaElement, e);
        schema.setContent(schemaElement);
        schemaElement.setSchema(schema);
        context.pop();
        context.fireDoneParsingEntity(SchemaConstants.QNAME_SCHEMA, schema);
        return schema;
    }

    protected void copyAttributesNoNs(SchemaElement target, Element source) {
        NamedNodeMapIterator iter = new NamedNodeMapIterator(source.getAttributes());
        while (iter.hasNext()) {
            Attr attr = (Attr)iter.next();
            if (attr.getName().equals(PREFIX_XMLNS) || attr.getName().startsWith(PREFIX_XMLNS_COLON)) continue;
            SchemaAttribute attribute = new SchemaAttribute(attr.getLocalName());
            attribute.setNamespaceURI(attr.getNamespaceURI());
            attribute.setValue(attr.getValue());
            target.addAttribute(attribute);
        }
    }

    protected void copyNamespaceDeclarations(SchemaElement target, Element source) {
        NamedNodeMapIterator iter = new NamedNodeMapIterator(source.getAttributes());
        while (iter.hasNext()) {
            Attr attr = (Attr)iter.next();
            if (attr.getName().equals(PREFIX_XMLNS)) {
                target.addPrefix("", attr.getValue());
                continue;
            }
            String prefix = XmlUtil.getPrefix(attr.getName());
            if (prefix == null || !prefix.equals(PREFIX_XMLNS)) continue;
            String nsPrefix = XmlUtil.getLocalPart(attr.getName());
            String uri = attr.getValue();
            target.addPrefix(nsPrefix, uri);
        }
    }

    protected void copyElementContent(SchemaElement target, Element source) {
        Element e2;
        Iterator iter = XmlUtil.getAllChildren(source);
        while (iter.hasNext() && (e2 = Util.nextElementIgnoringCharacterContent(iter)) != null) {
            SchemaElement newElement = new SchemaElement(e2.getLocalName());
            newElement.setNamespaceURI(e2.getNamespaceURI());
            this.copyNamespaceDeclarations(newElement, e2);
            this.copyAttributesNoNs(newElement, e2);
            this.copyElementContent(newElement, e2);
            target.addChild(newElement);
            newElement.setParent(target);
        }
    }
}

