/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.handlers.RestUtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class TargetUtil {
    public static boolean isCluster(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getClusters().contains(name);
    }

    public static boolean isInstance(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getInstances().contains(name);
    }

    public static List getStandaloneInstances() {
        List<Object> result = new ArrayList();
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        attrsMap.put("standaloneonly", "true");
        try {
            Map<String, Object> responseMap = RestUtil.restRequest(endpoint, attrsMap, "get", null, false);
            Map dataMap = (Map)responseMap.get("data");
            Map extraProps = (Map)dataMap.get("extraProperties");
            if (extraProps == null) {
                return result;
            }
            List props = (List)extraProps.get("instanceList");
            if (props == null) {
                return result;
            }
            result = RestUtilHandlers.getListFromMapKey(props, new String[0]);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getStandaloneInstances ; \nendpoint = " + endpoint + ", attrsMap=" + attrsMap);
        }
        return result;
    }

    public static List getClusters() {
        ArrayList<String> clusters;
        block2: {
            clusters = new ArrayList<String>();
            try {
                clusters.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getClusters") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return clusters;
    }

    public static List getInstances() {
        ArrayList<String> instances;
        block2: {
            instances = new ArrayList<String>();
            try {
                instances.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getInstances") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return instances;
    }

    public static List getConfigs() {
        ArrayList<String> config;
        block2: {
            config = new ArrayList<String>();
            try {
                config.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/configs/config").keySet());
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getClusters") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block2;
                ex.printStackTrace();
            }
        }
        return config;
    }

    public static List getClusteredInstances(String cluster) {
        ArrayList<String> instances = new ArrayList<String>();
        try {
            instances.addAll(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + cluster + "/server-ref").keySet());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(ex.getMessage());
        }
        return instances;
    }

    public static String getTargetEndpoint(String target) {
        try {
            List clusters;
            String encodedName = URLEncoder.encode(target, "UTF-8");
            String endpoint = (String)GuiUtil.getSessionValue("REST_URL");
            endpoint = target.equals("server") ? endpoint + "/servers/server/server" : ((clusters = TargetUtil.getClusters()).contains(target) ? endpoint + "/clusters/cluster/" + encodedName : endpoint + "/servers/server/" + encodedName);
            return endpoint;
        }
        catch (Exception ex) {
            GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getTargetEndpoint") + ex.getLocalizedMessage());
            if (GuiUtil.getLogger().isLoggable(Level.FINE)) {
                ex.printStackTrace();
            }
            return "";
        }
    }

    public static String getConfigName(String target) {
        String endpoint = TargetUtil.getTargetEndpoint(target);
        return (String)RestUtil.getAttributesMap(endpoint).get("configRef");
    }

    public static Collection<String> getHostNames(String target) {
        HashSet<String> hostNames = new HashSet<String>();
        hostNames.toArray();
        List clusters = TargetUtil.getClusters();
        List instances = new ArrayList<String>();
        if (clusters.contains(target)) {
            instances = TargetUtil.getClusteredInstances(target);
        } else {
            instances.add(target);
        }
        for (String instance : instances) {
            String hostName = null;
            String ep = (String)GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instance;
            String node = (String)RestUtil.getAttributesMap(ep).get("nodeRef");
            if (node != null) {
                ep = (String)GuiUtil.getSessionValue("REST_URL") + "/nodes/node/" + node;
                hostName = (String)RestUtil.getAttributesMap(ep).get("nodeHost");
            }
            if (hostName == null) {
                hostName = "localhost";
            }
            hostNames.add(hostName);
        }
        return hostNames;
    }
}

