/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.objectweb.asm.optimizer;

import org.glassfish.pfl.objectweb.asm.AnnotationVisitor;
import org.glassfish.pfl.objectweb.asm.Attribute;
import org.glassfish.pfl.objectweb.asm.FieldVisitor;
import org.glassfish.pfl.objectweb.asm.optimizer.AnnotationConstantsCollector;
import org.glassfish.pfl.objectweb.asm.optimizer.ConstantPool;

public class FieldConstantsCollector
implements FieldVisitor {
    private final FieldVisitor fv;
    private final ConstantPool cp;

    public FieldConstantsCollector(FieldVisitor fv, ConstantPool cp) {
        this.fv = fv;
        this.cp = cp;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.fv.visitAnnotation(desc, visible), this.cp);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.fv.visitAttribute(attr);
    }

    @Override
    public void visitEnd() {
        this.fv.visitEnd();
    }
}

