/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.enterprise.spi.io.BaseIndirectlySerializable;
import com.sun.logging.LogCleanerUtil;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.SessionLock;
import org.apache.catalina.session.StandardSessionContext;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.catalina.util.Enumerator;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class StandardSession
implements HttpSession,
Session,
Serializable {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    protected static final String SYNC_STRING = "com.sun.sync";
    static final Class<?>[] containerEventTypes = new Class[]{String.class, Object.class};
    protected static final String info = "StandardSession/1.0";
    private static final String[] excludedAttributes = new String[]{"javax.security.auth.subject"};
    protected static volatile HttpSessionContext sessionContext = null;
    private static final Short SERIALIZED_FORM_VERSION = Short.valueOf("1");
    private String sipAppSessionId = null;
    private String beKey;
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected transient String authType = null;
    protected transient Method containerEventMethod = null;
    protected long creationTime = 0L;
    protected transient int debug = 0;
    protected transient boolean expiring = false;
    protected transient StandardSessionFacade facade = null;
    protected String id = null;
    protected long lastAccessedTime = this.creationTime;
    protected transient ArrayList<SessionListener> listeners = new ArrayList();
    protected transient Manager manager = null;
    protected transient StandardContext context = null;
    protected int maxInactiveInterval = -1;
    protected boolean isNew = false;
    protected boolean isValid = false;
    protected transient Map<String, Object> notes = new Hashtable<String, Object>();
    protected transient Principal principal = null;
    protected long thisAccessedTime = this.creationTime;
    protected AtomicLong version = new AtomicLong(-1L);
    protected String ssoId = null;
    protected volatile long ssoVersion = 0L;
    protected transient SessionLock _sessionLock = new SessionLock();
    protected final Object sessionLockMonitor = new Object();

    public StandardSession(Manager manager) {
        this.setManager(manager);
        if (manager instanceof ManagerBase) {
            this.debug = ((ManagerBase)manager).getDebug();
        }
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Override
    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    @Override
    public String getId() {
        return this.getIdInternal();
    }

    @Override
    public String getIdInternal() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        String oldId = this.id;
        this.id = id;
        if (this.manager != null) {
            this.manager.add(this);
        }
        if (oldId == null) {
            this.tellNew();
        } else {
            HttpSessionEvent event = null;
            List<EventListener> listeners = this.context.getApplicationEventListeners();
            if (listeners.isEmpty()) {
                return;
            }
            for (EventListener eventListener : listeners) {
                if (!(eventListener instanceof HttpSessionIdListener)) continue;
                HttpSessionIdListener listener = (HttpSessionIdListener)eventListener;
                try {
                    this.fireContainerEvent(this.context, "beforeSessionIdChanged", listener);
                    if (event == null) {
                        event = new HttpSessionEvent(this.getSession());
                    }
                    listener.sessionIdChanged(event, oldId);
                    this.fireContainerEvent(this.context, "afterSessionIdChanged", listener);
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(this.context, "afterSessionIdChanged", listener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.log(rb.getString("AS-WEB-CORE-00389"), t);
                }
            }
        }
    }

    public void setBeKey(String beKey) {
        this.beKey = beKey;
    }

    public String getBeKey() {
        return this.beKey;
    }

    public void setSipApplicationSessionId(String id) {
        this.sipAppSessionId = id;
    }

    public String getSipApplicationSessionId() {
        return this.sipAppSessionId;
    }

    public void tellNew() {
        this.fireSessionEvent("createSession", null);
        HttpSessionEvent event = new HttpSessionEvent(this.getSession());
        for (HttpSessionListener listener : this.context.getSessionListeners()) {
            try {
                this.fireContainerEvent(this.context, "beforeSessionCreated", listener);
                listener.sessionCreated(event);
                this.fireContainerEvent(this.context, "afterSessionCreated", listener);
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(this.context, "afterSessionCreated", listener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log(rb.getString("AS-WEB-CORE-00390"), t);
            }
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public long getLastAccessedTime() {
        if (!this.isValid()) {
            throw new IllegalStateException("getLastAccessedTime: " + rb.getString("AS-WEB-CORE-00391"));
        }
        return this.lastAccessedTime;
    }

    public long getLastAccessedTimeInternal() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAcessedTime) {
        this.lastAccessedTime = lastAcessedTime;
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(Manager manager) {
        this.manager = manager;
        this.context = (StandardContext)manager.getContainer();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
        if (this.isValid && interval == 0) {
            this.expire();
        }
    }

    @Override
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    @Override
    public HttpSession getSession() {
        if (this.facade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final StandardSession fsession = this;
                this.facade = AccessController.doPrivileged(new PrivilegedAction<StandardSessionFacade>(){

                    @Override
                    public StandardSessionFacade run() {
                        return new StandardSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new StandardSessionFacade(this);
            }
        }
        return this.facade;
    }

    @Override
    public boolean isValid() {
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (this.isForegroundLocked()) {
            return true;
        }
        if (this.hasExpired()) {
            this.expire(true);
        }
        return this.isValid;
    }

    @Override
    public boolean getIsValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
        if (!isValid && this.getManager() instanceof PersistentManagerBase) {
            ((PersistentManagerBase)this.getManager()).addToInvalidatedSessions(this.id);
        }
    }

    @Override
    public void access() {
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        this.evaluateIfValid();
    }

    @Override
    public void endAccess() {
        this.isNew = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSessionListener(SessionListener listener) {
        ArrayList<SessionListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void expire() {
        this.expire(true);
    }

    public void expire(boolean notify) {
        this.expire(notify, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify, boolean persistentRemove) {
        if (this.expiring) {
            return;
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            block28: {
                PrivilegedSetTccl pa;
                if (this.manager == null) {
                    return;
                }
                this.expiring = true;
                ClassLoader oldTccl = null;
                if (this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
                    oldTccl = Thread.currentThread().getContextClassLoader();
                    if (Globals.IS_SECURITY_ENABLED) {
                        pa = new PrivilegedSetTccl(this.context.getLoader().getClassLoader());
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                    }
                }
                try {
                    List<HttpSessionListener> listeners = this.context.getSessionListeners();
                    if (!notify || listeners.isEmpty()) break block28;
                    HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                    int len = listeners.size();
                    for (int i = 0; i < len; ++i) {
                        HttpSessionListener listener = listeners.get(len - 1 - i);
                        try {
                            this.fireContainerEvent(this.context, "beforeSessionDestroyed", listener);
                            listener.sessionDestroyed(event);
                            this.fireContainerEvent(this.context, "afterSessionDestroyed", listener);
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                this.fireContainerEvent(this.context, "afterSessionDestroyed", listener);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.log(rb.getString("AS-WEB-CORE-00390"), t);
                        }
                    }
                }
                finally {
                    if (oldTccl != null) {
                        if (Globals.IS_SECURITY_ENABLED) {
                            pa = new PrivilegedSetTccl(oldTccl);
                            AccessController.doPrivileged(pa);
                        } else {
                            Thread.currentThread().setContextClassLoader(oldTccl);
                        }
                    }
                }
            }
            this.setValid(false);
            long timeNow = System.currentTimeMillis();
            int timeAlive = (int)((timeNow - this.creationTime) / 1000L);
            Manager i = this.manager;
            synchronized (i) {
                if (timeAlive > this.manager.getSessionMaxAliveTimeSeconds()) {
                    this.manager.setSessionMaxAliveTimeSeconds(timeAlive);
                }
                int numExpired = this.manager.getExpiredSessions();
                this.manager.setExpiredSessions(++numExpired);
                int average = this.manager.getSessionAverageAliveTimeSeconds();
                average = (average * (numExpired - 1) + timeAlive) / numExpired;
                this.manager.setSessionAverageAliveTimeSeconds(average);
            }
            if (persistentRemove) {
                this.manager.remove(this);
            } else if (this.manager instanceof PersistentManagerBase) {
                ((PersistentManagerBase)this.manager).remove(this, false);
            }
            this.expiring = false;
            String[] keys = this.keys();
            for (int i2 = 0; i2 < keys.length; ++i2) {
                this.removeAttribute(keys[i2], notify, false);
            }
            if (notify) {
                this.context.sessionExpiredEvent(this);
                this.fireSessionEvent("destroySession", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate() {
        this.context.sessionPassivatedStartEvent(this);
        try {
            HttpSessionEvent event = null;
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                Object attribute = this.getAttributeInternal(keys[i]);
                if (!(attribute instanceof HttpSessionActivationListener)) continue;
                if (event == null) {
                    event = new HttpSessionEvent(this.getSession());
                }
                ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
            }
        }
        finally {
            this.context.sessionPassivatedEndEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        this.context.sessionActivatedStartEvent(this);
        try {
            HttpSessionEvent event = null;
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                Object attribute = this.getAttributeInternal(keys[i]);
                if (!(attribute instanceof HttpSessionActivationListener)) continue;
                if (event == null) {
                    event = new HttpSessionEvent(this.getSession());
                }
                ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
            }
        }
        finally {
            this.context.sessionActivatedEndEvent(this);
        }
    }

    @Override
    public Object getNote(String name) {
        return this.notes.get(name);
    }

    @Override
    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    @Override
    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        this.listeners.clear();
        this.manager = null;
    }

    @Override
    public void removeNote(String name) {
        this.notes.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionListener(SessionListener listener) {
        ArrayList<SessionListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    @Override
    public boolean hasExpired() {
        return this.maxInactiveInterval >= 0 && System.currentTimeMillis() - this.thisAccessedTime >= (long)this.maxInactiveInterval * 1000L;
    }

    public long incrementVersion() {
        return this.version.incrementAndGet();
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    public void setVersion(long value) {
        this.version.set(value);
    }

    @Override
    public String getSsoId() {
        return this.ssoId;
    }

    @Override
    public void setSsoId(String ssoId) {
        this.ssoId = ssoId;
    }

    @Override
    public long getSsoVersion() {
        return this.ssoVersion;
    }

    @Override
    public void setSsoVersion(long value) {
        this.ssoVersion = value;
    }

    public String toString() {
        StringBuilder sb = null;
        sb = !this.isValid ? new StringBuilder() : new StringBuilder(1000);
        sb.append("StandardSession[");
        sb.append(this.id);
        sb.append("]");
        if (this.isValid) {
            Enumeration<String> attrNamesEnum = this.getAttributeNames();
            while (attrNamesEnum.hasMoreElements()) {
                String nextAttrName = attrNamesEnum.nextElement();
                Object nextAttrValue = this.getAttribute(nextAttrName);
                sb.append("\n");
                sb.append("attrName = " + nextAttrName);
                sb.append(" : attrValue = " + nextAttrValue);
            }
        }
        return sb.toString();
    }

    static StandardSession deserialize(ObjectInputStream ois, Manager manager) throws ClassNotFoundException, IOException {
        StandardSession result = null;
        Object obj = ois.readObject();
        if (obj instanceof StandardSession) {
            result = (StandardSession)obj;
        } else {
            result = (StandardSession)manager.createEmptySession();
            result.setCreationTime((Long)obj);
            result.readRemainingObject(ois);
        }
        return result;
    }

    @Override
    public long getCreationTime() {
        if (!this.isValid()) {
            throw new IllegalStateException("getCreationTime: " + rb.getString("AS-WEB-CORE-00391"));
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        if (this.context == null) {
            return null;
        }
        return this.context.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException("getAttribute: " + rb.getString("AS-WEB-CORE-00391"));
        }
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Enumeration<String> getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("getAttributeNames: " + rb.getString("AS-WEB-CORE-00391"));
        }
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid()) {
            throw new IllegalStateException("getValueNames: " + rb.getString("AS-WEB-CORE-00391"));
        }
        return this.keys();
    }

    protected boolean getSessionLockForForeground() {
        boolean result = false;
        StandardSession sess = this;
        long pollTime = 200L;
        int tryNumber = 0;
        int numTries = 7;
        boolean keepTrying = true;
        boolean lockResult = false;
        while (keepTrying) {
            lockResult = sess.lockForeground();
            if (lockResult) {
                keepTrying = false;
                result = true;
                break;
            }
            if (++tryNumber < numTries - 1) {
                pollTime *= 2L;
                continue;
            }
            sess.unlockBackground();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isForegroundLocked() {
        if (this._sessionLock == null) {
            return false;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            return this._sessionLock.isForegroundLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockBackground() {
        if (this._sessionLock == null) {
            return true;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            return this._sessionLock.lockBackground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockForeground() {
        if (this._sessionLock == null) {
            return true;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            return this._sessionLock.lockForeground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockForegroundCompletely() {
        if (this._sessionLock == null) {
            return;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            this._sessionLock.unlockForegroundCompletely();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForeground() {
        if (this._sessionLock == null) {
            return;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            this._sessionLock.unlockForeground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockBackground() {
        if (this._sessionLock == null) {
            return;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            this._sessionLock.unlockBackground();
        }
    }

    public SessionLock getSessionLock() {
        return this._sessionLock;
    }

    public void setSessionLock(SessionLock sessionLock) {
        this._sessionLock = sessionLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonHttpLockOccurred() {
        if (this._sessionLock == null) {
            return false;
        }
        Object object = this.sessionLockMonitor;
        synchronized (object) {
            return this._sessionLock.hasNonHttpLockOccurred();
        }
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("invalidate: " + rb.getString("AS-WEB-CORE-00391"));
        }
        if (!this.isForegroundLocked()) {
            this.getSessionLockForForeground();
        }
        try {
            this.expire();
        }
        finally {
            this.unlockForeground();
        }
    }

    public boolean isNew() {
        if (!this.isValid()) {
            throw new IllegalStateException("isNew: " + rb.getString("AS-WEB-CORE-00391"));
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, true, true);
    }

    public void removeAttribute(String name, boolean notify, boolean checkValid) {
        List<EventListener> listeners;
        if (name == null) {
            return;
        }
        if (!this.isValid() && checkValid) {
            throw new IllegalStateException("removeAttribute: " + rb.getString("AS-WEB-CORE-00391"));
        }
        Object value = this.attributes.remove(name);
        if (!notify || value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                this.context.fireContainerEvent("beforeSessionValueUnbound", null);
                ((HttpSessionBindingListener)value).valueUnbound(event);
                this.context.fireContainerEvent("afterSessionValueUnbound", null);
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterSessionValueUnbound", null);
            }
        }
        this.context.fireContainerEvent("sessionRemoveAttributeCalled", event);
        if (SYNC_STRING.equals(name)) {
            this.context.fireContainerEvent("sessionSync", new HttpSessionBindingEvent(this.getSession(), name));
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)eventListener;
            try {
                this.fireContainerEvent(this.context, "beforeSessionAttributeRemoved", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeRemoved(event);
                this.fireContainerEvent(this.context, "afterSessionAttributeRemoved", listener);
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(this.context, "afterSessionAttributeRemoved", listener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log(rb.getString("AS-WEB-CORE-00392"), t);
            }
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        Object unbound;
        if (name == null) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00393"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException("setAttribute: " + rb.getString("AS-WEB-CORE-00391"));
        }
        if (this.manager != null) {
            this.manager.checkSessionAttribute(name, value);
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                this.log(rb.getString("AS-WEB-CORE-00394"), t);
            }
        }
        if ((unbound = this.attributes.put(name, value)) != null && unbound instanceof HttpSessionBindingListener) {
            try {
                this.context.fireContainerEvent("beforeSessionValueUnbound", null);
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
                this.context.fireContainerEvent("afterSessionValueUnbound", null);
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterSessionValueUnbound", null);
                this.log(rb.getString("AS-WEB-CORE-00394"), t);
            }
        }
        if (SYNC_STRING.equals(name)) {
            this.context.fireContainerEvent("sessionSync", new HttpSessionBindingEvent(this.getSession(), name));
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)eventListener;
            try {
                if (unbound != null) {
                    this.fireContainerEvent(this.context, "beforeSessionAttributeReplaced", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, unbound);
                    }
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(this.context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                this.fireContainerEvent(this.context, "beforeSessionAttributeAdded", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeAdded(event);
                this.fireContainerEvent(this.context, "afterSessionAttributeAdded", listener);
            }
            catch (Throwable t) {
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(this.context, "afterSessionAttributeReplaced", listener);
                    } else {
                        this.fireContainerEvent(this.context, "afterSessionAttributeAdded", listener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log(rb.getString("AS-WEB-CORE-00392"), t);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable<String, Object>();
        }
        this.authType = null;
        Object obj = stream.readObject();
        short readSerializedFormVersion = 0;
        if (obj instanceof Short) {
            readSerializedFormVersion = (Short)obj;
            this.creationTime = (Long)stream.readObject();
        } else {
            this.creationTime = (Long)obj;
        }
        this.readRemainingObject(stream);
        this.sipAppSessionId = (String)stream.readObject();
        switch (readSerializedFormVersion) {
            case 0: {
                break;
            }
            case 1: {
                this.beKey = (String)stream.readObject();
                break;
            }
            default: {
                throw new IOException("Unable to deserialize into " + this.getClass().getName() + " due to unknown serializedFormVersion of " + readSerializedFormVersion);
            }
        }
    }

    private void readRemainingObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.version = new AtomicLong();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        Object obj = stream.readObject();
        if (obj instanceof Principal) {
            this.principal = (Principal)obj;
            this.id = (String)stream.readObject();
        } else {
            this.principal = null;
            this.id = (String)obj;
        }
        if (this.debug >= 2) {
            this.log("readObject() loading session " + this.id);
        }
        obj = stream.readObject();
        int n = 0;
        if (obj instanceof String) {
            this.authType = (String)obj;
            n = (Integer)stream.readObject();
        } else {
            n = (Integer)obj;
        }
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap<String, Object>();
        }
        boolean isValidSave = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (value instanceof String && value.equals(NOT_SERIALIZED)) continue;
            if (this.debug >= 2) {
                this.log("  loading attribute '" + name + "' with value '" + value + "'");
            }
            this.attributes.put(name, value);
        }
        this.isValid = isValidSave;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(SERIALIZED_FORM_VERSION);
        stream.writeObject(this.creationTime);
        stream.writeObject(this.lastAccessedTime);
        stream.writeObject(this.maxInactiveInterval);
        stream.writeObject(this.isNew);
        stream.writeObject(this.isValid);
        stream.writeObject(this.thisAccessedTime);
        boolean serialPrincipal = false;
        if (this.principal instanceof Serializable) {
            serialPrincipal = true;
            stream.writeObject(this.principal);
        }
        stream.writeObject(this.id);
        if (this.debug >= 2) {
            this.log("writeObject() storing session " + this.id);
        }
        if (serialPrincipal && this.authType != null) {
            stream.writeObject(this.authType);
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList<Object> saveValues = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            Object value = this.attributes.get(keys[i]);
            if (value == null) continue;
            if (StandardSession.isSerializable(value)) {
                saveNames.add(keys[i]);
                saveValues.add(value);
                continue;
            }
            this.removeAttribute(keys[i], true, true);
        }
        int n = saveNames.size();
        stream.writeObject(n);
        for (int i = 0; i < n; ++i) {
            String msg;
            stream.writeObject(saveNames.get(i));
            try {
                stream.writeObject(saveValues.get(i));
                if (this.debug < 2) continue;
                this.log("  storing attribute '" + (String)saveNames.get(i) + "' with value '" + saveValues.get(i) + "'");
                continue;
            }
            catch (NotSerializableException e) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00395"), saveNames.get(i), this.id);
                this.log(msg, e);
                stream.writeObject(NOT_SERIALIZED);
                if (this.debug < 2) continue;
                this.log("  storing attribute '" + (String)saveNames.get(i) + "' with value NOT_SERIALIZED");
                continue;
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof NotSerializableException) {
                    msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00395"), saveNames.get(i), this.id);
                    this.log(msg, ioe);
                    stream.writeObject(NOT_SERIALIZED);
                    if (this.debug < 2) continue;
                    this.log("  storing attribute '" + (String)saveNames.get(i) + "' with value NOT_SERIALIZED");
                    continue;
                }
                throw ioe;
            }
        }
        stream.writeObject(this.sipAppSessionId);
        stream.writeObject(this.beKey);
    }

    protected boolean exclude(String name) {
        for (int i = 0; i < excludedAttributes.length; ++i) {
            if (!name.equalsIgnoreCase(excludedAttributes[i])) continue;
            return true;
        }
        return false;
    }

    protected void evaluateIfValid() {
        if (!this.isValid || this.expiring || this.maxInactiveInterval < 0) {
            return;
        }
        this.isValid();
    }

    protected void fireContainerEvent(Context context, String type, Object data) throws Exception {
        if (!(context instanceof StandardContext)) {
            return;
        }
        if (this.containerEventMethod == null) {
            this.containerEventMethod = context.getClass().getMethod("fireContainerEvent", containerEventTypes);
        }
        Object[] containerEventParams = new Object[]{type, data};
        this.containerEventMethod.invoke((Object)context, containerEventParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String type, Object data) {
        if ("createSession".equals(type)) {
            this.context.sessionCreatedEvent(this);
        } else {
            this.context.sessionDestroyedEvent(this);
        }
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent event = new SessionEvent(this, type, data);
        SessionListener[] list = new SessionListener[]{};
        ArrayList<SessionListener> arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].sessionEvent(event);
        }
    }

    protected String[] keys() {
        if (this.attributes.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : this.attributes.keySet()) {
                list.add(key);
            }
            return list.toArray(new String[list.size()]);
        }
        return EMPTY_ARRAY;
    }

    protected Object getAttributeInternal(String name) {
        return this.attributes.get(name);
    }

    protected void log(String message) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(message);
        } else {
            log.log(Level.INFO, "StandardSession: " + message);
        }
    }

    protected void log(String message, Throwable t) {
        message = LogCleanerUtil.neutralizeForLog((String)message);
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(message, t);
        } else {
            log.log(Level.WARNING, "StandardSession: " + message, t);
        }
    }

    static boolean isSerializable(Object value) {
        return value instanceof Serializable || value instanceof BaseIndirectlySerializable || value instanceof javax.naming.Context;
    }
}

