/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.impl.helper.ComponentMethod;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.inject.ActivatorParameter;
import org.apache.felix.scr.impl.inject.Annotations;
import org.apache.felix.scr.impl.inject.BaseMethod;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.inject.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class ActivateMethod
extends BaseMethod<ActivatorParameter, Object>
implements ComponentMethod {
    protected static final Class<?> COMPONENT_CONTEXT_CLASS = ComponentContext.class;
    protected static final Class<?> BUNDLE_CONTEXT_CLASS = BundleContext.class;
    protected static final Class<?> INTEGER_CLASS = Integer.class;
    protected final boolean m_supportsInterfaces;

    public ActivateMethod(String methodName, boolean methodRequired, Class<?> componentClass, DSVersion dsVersion, boolean configurableServiceProperties, boolean supportsInterfaces) {
        super(methodName, methodRequired, componentClass, dsVersion, configurableServiceProperties);
        this.m_supportsInterfaces = supportsInterfaces;
    }

    @Override
    protected BaseMethod.MethodInfo<Object> doFindMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        boolean suitableMethodNotAccessible = false;
        try {
            Method method = this.getMethod(targetClass, this.getMethodName(), new Class[]{COMPONENT_CONTEXT_CLASS}, acceptPrivate, acceptPackage, logger);
            if (method != null) {
                return new BaseMethod.MethodInfo<Object>(method);
            }
        }
        catch (SuitableMethodNotAccessibleException thrown) {
            logger.log(4, "SuitableMethodNotAccessible", thrown);
            suitableMethodNotAccessible = true;
        }
        if (this.getDSVersion().isDS11()) {
            List<Method> methods = this.getSortedMethods(targetClass);
            for (Method m : methods) {
                Class<?>[] parameterTypes = m.getParameterTypes();
                if (parameterTypes.length == 1) {
                    Class<?> type = parameterTypes[0];
                    if (type == BUNDLE_CONTEXT_CLASS) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (this.getDSVersion().isDS13() && this.isAnnotation(type)) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (type == ClassUtils.MAP_CLASS) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (type == Integer.TYPE) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (type != Integer.class) continue;
                    if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                        return new BaseMethod.MethodInfo<Object>(m);
                    }
                    suitableMethodNotAccessible = true;
                    continue;
                }
                if (parameterTypes.length > 1) {
                    boolean accept = true;
                    for (Class<?> type : parameterTypes) {
                        boolean bl = accept = type == COMPONENT_CONTEXT_CLASS || type == BUNDLE_CONTEXT_CLASS || type == ClassUtils.MAP_CLASS || this.isDeactivate() && (type == Integer.TYPE || type == Integer.class) || this.getDSVersion().isDS13() && this.isAnnotation(type);
                        if (!accept) break;
                    }
                    if (!accept) continue;
                    if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                        return new BaseMethod.MethodInfo<Object>(m);
                    }
                    suitableMethodNotAccessible = true;
                    continue;
                }
                if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                    return new BaseMethod.MethodInfo<Object>(m);
                }
                suitableMethodNotAccessible = true;
            }
        }
        if (suitableMethodNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    @Override
    protected void setTypes(Object types) {
    }

    boolean isDeactivate() {
        return false;
    }

    List<Method> getSortedMethods(Class<?> targetClass) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : methods = targetClass.getDeclaredMethods()) {
            if (!m.getName().equals(this.getMethodName())) continue;
            result.add(m);
        }
        Collections.sort(result, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                int l1 = m1.getParameterTypes().length;
                int l2 = m2.getParameterTypes().length;
                if (l1 == 0) {
                    return l2;
                }
                if (l2 == 0) {
                    return -l1;
                }
                if (l1 == 1 && l2 == 1) {
                    Class<?> t1 = m1.getParameterTypes()[0];
                    Class<?> t2 = m2.getParameterTypes()[0];
                    if (t1 == COMPONENT_CONTEXT_CLASS) {
                        return -1;
                    }
                    if (t2 == COMPONENT_CONTEXT_CLASS) {
                        return 1;
                    }
                    if (t1 == BUNDLE_CONTEXT_CLASS) {
                        return -1;
                    }
                    if (t2 == BUNDLE_CONTEXT_CLASS) {
                        return 1;
                    }
                    if (ActivateMethod.this.isAnnotation(t1)) {
                        return ActivateMethod.this.isAnnotation(t2) ? 0 : -1;
                    }
                    if (ActivateMethod.this.isAnnotation(t2)) {
                        return 1;
                    }
                    if (t1 == ClassUtils.MAP_CLASS) {
                        return -1;
                    }
                    if (t2 == ClassUtils.MAP_CLASS) {
                        return 1;
                    }
                    if (t1 == Integer.TYPE) {
                        return -1;
                    }
                    if (t2 == Integer.TYPE) {
                        return 1;
                    }
                    if (t1 == Integer.class) {
                        return -1;
                    }
                    if (t2 == Integer.class) {
                        return 1;
                    }
                    return 0;
                }
                return l1 - l2;
            }
        });
        return result;
    }

    private boolean isAnnotation(Class<?> t1) {
        return t1.isAnnotation() || this.m_supportsInterfaces && t1.isInterface() && t1 != ClassUtils.MAP_CLASS;
    }

    @Override
    protected Object[] getParameters(Method method, ActivatorParameter rawParameter) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        ActivatorParameter ap = rawParameter;
        Object[] param = new Object[parameterTypes.length];
        for (int i = 0; i < param.length; ++i) {
            param[i] = parameterTypes[i] == COMPONENT_CONTEXT_CLASS ? ap.getComponentContext() : (parameterTypes[i] == BUNDLE_CONTEXT_CLASS ? ap.getComponentContext().getBundleContext() : (parameterTypes[i] == ClassUtils.MAP_CLASS ? ap.getComponentContext().getProperties() : (parameterTypes[i] == INTEGER_CLASS || parameterTypes[i] == Integer.TYPE ? Integer.valueOf(ap.getReason()) : Annotations.toObject(parameterTypes[i], (Map)((Object)ap.getComponentContext().getProperties()), ap.getComponentContext().getBundleContext().getBundle(), this.m_supportsInterfaces))));
        }
        return param;
    }

    @Override
    protected String getMethodNamePrefix() {
        return "activate";
    }

    @Override
    public MethodResult invoke(Object componentInstance, ComponentContext componentContext, int reason, MethodResult methodCallFailureResult, SimpleLogger logger) {
        return this.invoke(componentInstance, new ActivatorParameter(componentContext, reason), methodCallFailureResult, logger);
    }

    @Override
    public MethodResult invoke(Object componentInstance, ActivatorParameter rawParameter, MethodResult methodCallFailureResult, SimpleLogger logger) {
        if (this.methodExists(logger)) {
            return super.invoke(componentInstance, rawParameter, methodCallFailureResult, logger);
        }
        return null;
    }
}

