/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijpa.dd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijpa.dd.ObjectFactory;
import org.glassfish.osgijpa.dd.Persistence;

public class PersistenceXMLReaderWriter {
    private static final Logger logger = Logger.getLogger(PersistenceXMLReaderWriter.class.getPackage().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistence read(URL pxmlURL) throws IOException {
        InputStream is = pxmlURL.openStream();
        try {
            Persistence persistence = this.read(is);
            return persistence;
        }
        finally {
            is.close();
        }
    }

    public Persistence read(InputStream is) throws IOException {
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller();
            return (Persistence)unmarshaller.unmarshal(is);
        }
        catch (JAXBException je) {
            je.printStackTrace();
            IOException ioe = new IOException();
            ioe.initCause(je);
            throw ioe;
        }
    }

    public void write(Persistence persistence, OutputStream os) throws IOException {
        try {
            this.getMarshaller(persistence.getClass()).marshal((Object)persistence, os);
        }
        catch (JAXBException je) {
            je.printStackTrace();
            IOException ioe = new IOException();
            ioe.initCause(je);
            throw ioe;
        }
    }

    public void write(Persistence persistence, Writer writer) throws IOException {
        try {
            this.getMarshaller(persistence.getClass()).marshal((Object)persistence, writer);
        }
        catch (JAXBException je) {
            je.printStackTrace();
            IOException ioe = new IOException();
            ioe.initCause(je);
            throw ioe;
        }
    }

    private Marshaller getMarshaller(Class<?> clazz) throws JAXBException {
        JAXBContext jc = this.getJAXBContext();
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return marshaller;
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jc = this.getJAXBContext();
        return jc.createUnmarshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext() throws JAXBException {
        Thread thread = Thread.currentThread();
        ClassLoader oldCL = thread.getContextClassLoader();
        try {
            JAXBContext jc;
            ClassLoader ccl = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getCommonClassLoader();
            thread.setContextClassLoader(ccl);
            JAXBContext jAXBContext = jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            return jAXBContext;
        }
        finally {
            thread.setContextClassLoader(oldCL);
        }
    }
}

