/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization.ordering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.ordering.PropOrderStrategy;

public class PropertyOrdering {
    private PropOrderStrategy propertyOrderStrategy;

    public PropertyOrdering(PropOrderStrategy propertyOrderStrategy) {
        Objects.requireNonNull(propertyOrderStrategy);
        this.propertyOrderStrategy = propertyOrderStrategy;
    }

    public List<PropertyModel> orderProperties(List<PropertyModel> properties, ClassModel classModel) {
        HashMap byReadName = new HashMap();
        properties.stream().forEach(propertyModel -> byReadName.put(propertyModel.getReadName(), propertyModel));
        String[] order = classModel.getClassCustomization().getPropertyOrder();
        ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
        if (order != null) {
            for (String propName : order) {
                PropertyModel remove = (PropertyModel)byReadName.remove(propName);
                if (remove == null) continue;
                sortedProperties.add(remove);
            }
        }
        sortedProperties.addAll(this.propertyOrderStrategy.sortProperties(byReadName.values()));
        return sortedProperties;
    }

    public PropOrderStrategy getPropertyOrderStrategy() {
        return this.propertyOrderStrategy;
    }
}

