/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.v3.admin.JobManagerService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AuthorizationPreprocessor;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.progress.JobInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JobAuthorizationAttributeProcessor
implements AuthorizationPreprocessor {
    private static final String USER_ATTRIBUTE_NAME = "user";
    public static final String JOB_RESOURCE_NAME_PREFIX_NO_SLASH = "jobs/job";
    public static final String JOB_RESOURCE_NAME_PREFIX = "jobs/job/";
    public static final Pattern JOB_PATTERN = Pattern.compile("(?:jobs/job(?:/(\\d*))?)");
    @Inject
    private JobManagerService jobManager;

    public void describeAuthorization(Subject subject, String resourceName, String action, AdminCommand command, Map<String, Object> context, Map<String, String> subjectAttributes, Map<String, String> resourceAttributes, Map<String, String> actionAttributes) {
        JobInfo jobInfo;
        Matcher m = JOB_PATTERN.matcher(resourceName);
        if (!m.matches()) {
            return;
        }
        if (m.groupCount() == 0) {
            return;
        }
        String jobID = m.group(1);
        Job job = this.jobManager.get(jobID);
        String userID = null;
        if (job != null && job.getSubjectUsernames().size() > 0) {
            userID = (String)job.getSubjectUsernames().get(0);
        } else if (this.jobManager.getCompletedJobs(this.jobManager.getJobsFile()) != null && (jobInfo = this.jobManager.getCompletedJobForId(jobID)) != null) {
            userID = jobInfo.user;
        }
        if (userID != null) {
            resourceAttributes.put(USER_ATTRIBUTE_NAME, userID);
        }
    }
}

