/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;

public class DetachListener
implements AdminCommandEventBroker.AdminCommandListener<GfSseInboundEvent> {
    private static final LocalStringsImpl strings = new LocalStringsImpl(DetachListener.class);
    private final Logger logger;
    private final RemoteRestAdminCommand rac;
    private final boolean terse;

    public DetachListener(Logger logger, RemoteRestAdminCommand rac, boolean terse) {
        this.logger = logger;
        this.rac = rac;
        this.terse = terse;
    }

    public void onAdminCommandEvent(String name, GfSseInboundEvent event) {
        try {
            AdminCommandState acs = (AdminCommandState)event.getData(AdminCommandState.class, "application/json");
            String id = acs.getId();
            if (StringUtils.ok((String)id)) {
                if (this.terse) {
                    this.rac.closeSse(id, ActionReport.ExitCode.SUCCESS);
                } else {
                    this.rac.closeSse(strings.get("detach.jobid", new Object[]{id}), ActionReport.ExitCode.SUCCESS);
                }
            } else {
                this.logger.log(Level.SEVERE, strings.getString("detach.noid", "Command was started but id was not retrieved. Can not detach."));
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }
}

