/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.ApplicationLifecycleInterceptor;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class InterceptorNotifier {
    private boolean[] isBeforeReported = InterceptorNotifier.initialIsReported();
    private boolean[] isAfterReported = InterceptorNotifier.initialIsReported();
    private Collection<ApplicationLifecycleInterceptor> interceptors;
    private ExtendedDeploymentContext dc = null;

    private static boolean[] initialIsReported() {
        boolean[] result = new boolean[ExtendedDeploymentContext.Phase.values().length];
        Arrays.fill(result, false);
        return result;
    }

    public InterceptorNotifier(ServiceLocator habitat, DeploymentContext basicDC) {
        if (basicDC != null) {
            if (!(basicDC instanceof ExtendedDeploymentContext)) {
                throw new IllegalArgumentException(basicDC.getClass().getName());
            }
            this.dc = (ExtendedDeploymentContext)ExtendedDeploymentContext.class.cast(basicDC);
        }
        this.interceptors = habitat.getAllServices(ApplicationLifecycleInterceptor.class, new Annotation[0]);
    }

    synchronized void ensureBeforeReported(ExtendedDeploymentContext.Phase phase) {
        if (this.isBeforeReported[phase.ordinal()]) {
            return;
        }
        for (ApplicationLifecycleInterceptor i : this.interceptors) {
            i.before(phase, this.dc);
        }
        this.isBeforeReported[phase.ordinal()] = true;
    }

    synchronized void ensureAfterReported(ExtendedDeploymentContext.Phase phase) {
        if (this.isAfterReported[phase.ordinal()]) {
            return;
        }
        for (ApplicationLifecycleInterceptor i : this.interceptors) {
            i.after(phase, this.dc);
        }
        this.isAfterReported[phase.ordinal()] = true;
    }

    ExtendedDeploymentContext dc() {
        return this.dc;
    }
}

