/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.mex.MessagesMessages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

class MEXAddressResolver
extends PortAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(MEXAddressResolver.class.getName());
    private final QName service;
    private final String port;
    private final String address;

    MEXAddressResolver(@NotNull QName serviceName, @NotNull QName portName, @NotNull String address) {
        this.service = serviceName;
        this.port = portName.getLocalPart();
        this.address = address;
    }

    @Override
    public String getAddressFor(@NotNull QName serviceName, @NotNull String portName) {
        return this.address;
    }

    @Override
    public String getAddressFor(@NotNull QName serviceName, @NotNull String portName, String currentAddress) {
        String result;
        block7: {
            LOGGER.entering(MEXAddressResolver.class.getName(), "getAddressFor", new Object[]{serviceName, portName, currentAddress});
            result = null;
            if (this.service.equals(serviceName) && this.port.equals(portName)) {
                result = this.getAddressFor(serviceName, portName);
                if (currentAddress != null) {
                    try {
                        URL addressUrl = new URL(this.address);
                        try {
                            URL currentAddressUrl = new URL(currentAddress);
                            if (currentAddressUrl.getProtocol().toLowerCase().equals("http") && addressUrl.getProtocol().toLowerCase().equals("https")) {
                                result = currentAddress;
                                LOGGER.fine(MessagesMessages.MEX_0019_LEAVE_ADDRESS(currentAddress, portName));
                                break block7;
                            }
                            LOGGER.fine(MessagesMessages.MEX_0018_REPLACE_ADDRESS(currentAddress, portName, result));
                        }
                        catch (MalformedURLException ex) {
                            LOGGER.fine(MessagesMessages.MEX_0020_CURRENT_ADDRESS_NO_URL(currentAddress, portName));
                        }
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.fine(MessagesMessages.MEX_0021_NEW_ADDRESS_NO_URL(this.address, portName));
                    }
                }
            }
        }
        LOGGER.exiting(MEXAddressResolver.class.getName(), "getAddressFor", result);
        return result;
    }
}

