/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttachmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class HolderGenerator
extends GeneratorBase {
    private Set types;
    private Port port;
    private Map generatedHolderClassMap;

    private void init() {
        this.generatedHolderClassMap = new HashMap();
    }

    public HolderGenerator() {
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new HolderGenerator(model, config, properties);
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new HolderGenerator(model, config, properties, ver);
    }

    private HolderGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        this.init();
    }

    private HolderGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        this(model, config, properties);
    }

    @Override
    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    @Override
    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    @Override
    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.port = port;
    }

    @Override
    protected void postVisitPort(Port port) throws Exception {
        this.port = null;
        super.postVisitPort(port);
    }

    @Override
    public void visit(SOAPCustomType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    public void visit(SOAPSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    public void visit(SOAPAnyType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    public void visit(LiteralEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitSOAPArrayType(type);
    }

    @Override
    protected void visitSOAPListType(SOAPListType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitSOAPListType(type);
    }

    @Override
    protected void visitLiteralListType(LiteralListType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitLiteralListType(type);
    }

    @Override
    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitSOAPStructureType(type);
    }

    @Override
    protected void visitLiteralSimpleType(LiteralSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    protected void visitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.visitLiteralSequenceType(type);
    }

    @Override
    protected void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
        super.preVisitLiteralAllType(type);
    }

    @Override
    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    @Override
    protected void visitLiteralAttachmentType(LiteralAttachmentType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (type.getJavaType().isHolder()) {
            this.generateHolder(type);
        }
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private void generateHolder(AbstractType type) {
        if (type.getJavaType().isHolderPresent()) {
            return;
        }
        try {
            String className = this.env.getNames().holderClassName(this.port, type);
            if (className.startsWith("javax.xml.rpc.holders.")) {
                return;
            }
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            if (this.generatedHolderClassMap.get(className) == null) {
                GeneratedFileInfo fi = new GeneratedFileInfo();
                fi.setFile(classFile);
                fi.setType("Holder");
                this.env.addGeneratedFile(fi);
                IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
                this.writePackage(out, className);
                out.pln();
                this.writeClassDecl(out, className);
                this.writeMembers(out, type);
                out.pln();
                this.writeClassConstructor(out, className, type);
                out.pOln("}");
                out.close();
                this.generatedHolderClassMap.put(className, type.getJavaType());
            }
        }
        catch (Exception e) {
            HolderGenerator.fail(e);
        }
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        p.plnI("public class " + Names.stripQualifier(className) + " implements javax.xml.rpc.holders.Holder {");
    }

    private void writeMembers(IndentingWriter p, AbstractType type) throws IOException {
        p.pln("public " + type.getJavaType().getName() + " value;");
    }

    private void writeClassConstructor(IndentingWriter p, String className, AbstractType type) throws IOException {
        p.pln("public " + Names.stripQualifier(className) + "() {");
        p.pln("}");
        p.pln();
        p.plnI("public " + Names.stripQualifier(className) + "(" + type.getJavaType().getName() + " " + this.env.getNames().getTypeMemberName(type) + ") {");
        p.pln("this.value = " + this.env.getNames().getTypeMemberName(type) + ";");
        p.pOln("}");
    }
}

