/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class Environment {
    private static String PREFIX = "AS_ADMIN_";
    private static String SHORT_PREFIX = "AS_";
    private Map<String, String> env = new HashMap<String, String>();
    private boolean debug = false;
    private boolean trace = false;
    private File logfile = null;

    public static void setPrefix(String p) {
        PREFIX = p;
    }

    public static String getPrefix() {
        return PREFIX;
    }

    public static void setShortPrefix(String p) {
        SHORT_PREFIX = p;
    }

    public static String getDebugVar() {
        return SHORT_PREFIX + "DEBUG";
    }

    public Environment() {
        this(false);
    }

    public Environment(boolean ignoreEnvironment) {
        if (ignoreEnvironment) {
            return;
        }
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            if (!e.getKey().startsWith(PREFIX)) continue;
            this.env.put(e.getKey().toUpperCase(Locale.ENGLISH), e.getValue());
        }
        String debugFlag = "Debug";
        String debugProp = Environment.getDebugVar();
        this.debug = System.getProperty(debugFlag) != null || Boolean.parseBoolean(System.getenv(debugProp)) || Boolean.getBoolean(debugProp);
        String traceProp = SHORT_PREFIX + "TRACE";
        this.trace = System.getProperty(traceProp) != null || Boolean.parseBoolean(System.getenv(traceProp)) || Boolean.getBoolean(traceProp);
        String logProp = SHORT_PREFIX + "LOGFILE";
        String fname = System.getProperty(logProp);
        if (fname == null) {
            fname = System.getenv(logProp);
        }
        if (fname != null) {
            File f = new File(fname);
            try {
                if ((f.exists() || f.createNewFile()) && f.isFile() && f.canWrite()) {
                    this.logfile = f;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean getBooleanOption(String name) {
        return Boolean.parseBoolean(this.env.get(this.optionToEnv(name)));
    }

    public String getStringOption(String name) {
        return this.env.get(this.optionToEnv(name));
    }

    public boolean hasOption(String name) {
        return this.env.containsKey(this.optionToEnv(name));
    }

    public String get(String name) {
        return this.env.get(name);
    }

    public String put(String name, String value) {
        return this.env.put(name, value);
    }

    public void remove(String name) {
        this.env.remove(name);
    }

    public String putOption(String name, String value) {
        return this.env.put(this.optionToEnv(name), value);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.env.entrySet();
    }

    private String optionToEnv(String name) {
        return PREFIX + name.replace('-', '_').toUpperCase(Locale.ENGLISH);
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean trace() {
        return this.trace;
    }

    public File getDebugLogfile() {
        return this.logfile;
    }
}

